/*
vParseChargingSpotDataforJPN * fc_usb_tcu_PRC_JSONParser.cpp
 *
 *  Created on: Apr 20, 2015
 *      Author: kl81hc
 */

#include "fc_usb_tcu_PRC_JSONParser.h"
//#include "fc_usb_tcu_AppMain.h"
//#include "I_fc_usb_tcu_KDSHandler.h"
#ifndef VARIANT_S_FTR_ENABLE_UNIT_TEST
#include "fc_usb_tcu_ServiceFc_usb_tcuIf.h"
#endif

#include "fc_usb_tcu_trace_classes.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_USB_TCU_EVENTMANG_SOCKET
#include "trcGenProj/Header/fc_usb_tcu_PRC_JSONParser.cpp.trc.h"
#endif


fc_usb_tcu_PRC_JSONParser::fc_usb_tcu_PRC_JSONParser(fc_usb_tcu_tclAppMain* poMainAppl):I_fc_usb_tcu_JSONParser(poMainAppl)
{

}

fc_usb_tcu_PRC_JSONParser::~fc_usb_tcu_PRC_JSONParser()
{

}

/******************************************** PARSE CHANNEL DATA *************************************************************************/

tBool fc_usb_tcu_PRC_JSONParser::vParseChannelDataJSON(Json::Value& root, T_tcu_channel_data_result& oChannelData)
{
	ETG_TRACE_USR2(("<< parseChannelDataJSON"));
	tBool bIsParsingSuccess = FALSE;

	//Get ChannelData JSON message
	Json::Value jChannelData;
	bIsParsingSuccess = jsonUtils.getJSONArray(root, json_utils::CHANNEL_DATA, jChannelData);

	if (bIsParsingSuccess == TRUE)
	{
		//Resize
		oChannelData.ChannelData.resize(jChannelData.size());
		for (tC16 i=0; i < jChannelData.size(); i++)
		{
		  //Get ChannelDataInformationHeaderPart JSON message
		  bIsParsingSuccess  = parseChannelDataInformationHeaderPart(jChannelData[i], oChannelData.ChannelData[i].ChannelDataInformationHeaderPart);

		  //Get parseChannelDataInformationRecordPart JSON message
		  if(bIsParsingSuccess == TRUE)
		  {
			  bIsParsingSuccess = parseChannelDataInformationRecordPart(jChannelData[i], oChannelData.ChannelData[i]);
		  }

		  //Get ExecutionInformation

		  if(bIsParsingSuccess) {
			  oChannelData.ChannelData[i].ExecutionInformation.resize(1);

			  bIsParsingSuccess = parseExecutionInformation(jChannelData[i],oChannelData.ChannelData[i].ExecutionInformation[0]);
		  }
		}
	}

	/*ToDo: These null checks can be removed by creating a parameterized constructor with m_poUsbTcu. Mani Arjunan*/
	if(bIsParsingSuccess == FALSE)
	{
		ETG_TRACE_USR2(("parse failed "));
	}

	return bIsParsingSuccess;
}

tBool fc_usb_tcu_PRC_JSONParser::parseChannelDataInformationHeaderPart(Json::Value& jChannelData, T_tcu_channel_data_information_header& oDest)
{
	ETG_TRACE_USR2(("-> parseChannelDataInformationHeaderPart()"));
	tBool bIsParsingSuccess = FALSE;

	Json::Value jChannelDataInformationHeaderPart;
	bIsParsingSuccess = jsonUtils.getJSONObject(jChannelData, json_utils::CHANNEL_DATA_INFO_HEADER_PART, jChannelDataInformationHeaderPart);
	/*####### ChannelDataInformationHeaderPart BEGIN ########*/

	//Get the channel info type
	tU8 u8ChannelInfoType = 0;
	T_e8_tcu_Channel_Info_Type e8ChannelInfoType;
	ETG_TRACE_USR1(("jChannelData JSON =\n %s", jChannelDataInformationHeaderPart.toStyledString().c_str()));
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.gettU8UInt(jChannelDataInformationHeaderPart, json_utils::U8_CHANNEL_INFO_TYPE, u8ChannelInfoType);
	}

	tU16 u16ChannelID = 0;
	if(bIsParsingSuccess == TRUE)
	{
		// Set info_type as enum.
		e8ChannelInfoType = T_e8_tcu_Channel_Info_Type::tenType(u8ChannelInfoType);

		//Get the channel ID
		bIsParsingSuccess = jsonUtils.gettU16UInt(jChannelDataInformationHeaderPart, json_utils::U16_CHANNEL_ID, u16ChannelID);
	}

	//Get the channel name
	bpstl::string strChannelName;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.getString(jChannelDataInformationHeaderPart, json_utils::STR_CHANNEL_NAME, strChannelName);
	}

	//Get the channel name for TTS
	bpstl::string strChannelNameForTTS;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.getString(jChannelDataInformationHeaderPart, json_utils::STR_CHANNEL_NAME_FOR_TTS, strChannelNameForTTS);
	}

	//Get the Channel action SWID.
	tU8 u8ChannelActionSWID = 0;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.gettU8UInt(jChannelDataInformationHeaderPart, json_utils::U8_CHANNEL_ACTION_SWID, u8ChannelActionSWID);
	}

	//Get the Channel action SW parameters.
	tU32 u32ChannelActionSWParam = 0;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.gettU32UInt(jChannelDataInformationHeaderPart, json_utils::U32_CHANNEL_ACTION_SW_PARAM, u32ChannelActionSWParam);
	}

	//Get the Channel Action SW Name.
	bpstl::string strChannelActionSWName;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.getString(jChannelDataInformationHeaderPart, json_utils::STR_CHANNEL_ACTION_SW_NAME, strChannelActionSWName);
	}

	//Get the Moving Restriction Flag control.
	tU8 u8MovingRestrictionFlagCtrl = 0;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.gettU8UInt(jChannelDataInformationHeaderPart, json_utils::U8_MOVING_RESTRICTION_FLAG_CTRL, u8MovingRestrictionFlagCtrl);
	}

	//Get the number of channel contents
	tU8 u8NumOfChannelContents = 0;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.gettU8UInt(jChannelDataInformationHeaderPart, json_utils::U8_NUM_OF_CHANNEL_CONTENTS, u8NumOfChannelContents);
	}

	//Get the number of execution info
	tU8 u8NumOfExecInfo = 0;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.gettU8UInt(jChannelDataInformationHeaderPart, json_utils::U8_NUM_OF_EXEC_INFO, u8NumOfExecInfo);
	}

	//Get the number of channel contents at one time
	tU8 u8NumOfChannelContentsAtOneTime = 0;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.gettU8UInt(jChannelDataInformationHeaderPart, json_utils::U8_NUM_OF_CHANNEL_CONTENTS_AT_ONE_TIME, u8NumOfChannelContentsAtOneTime);
	}

	//Get the total number of channel contents
	tU8 u8TotalNumOfChannelContents = 0;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.gettU8UInt(jChannelDataInformationHeaderPart, json_utils::U8_TOTAL_NUM_OF_CHANNEL_CONTENTS, u8TotalNumOfChannelContents);
	}

	if(bIsParsingSuccess == TRUE)
	{
		T_tcu_channel_data_information_header oChannelDataInformationHeaderPart(
				e8ChannelInfoType,
				u16ChannelID,
				strChannelName,
				u8NumOfChannelContents,
				u8NumOfExecInfo,
				u8NumOfChannelContentsAtOneTime,
				u8TotalNumOfChannelContents,
				strChannelNameForTTS,
				u8ChannelActionSWID,
				u32ChannelActionSWParam,
				strChannelActionSWName,
				u8MovingRestrictionFlagCtrl
				);
		oDest = oChannelDataInformationHeaderPart;
	}

	/*####### ChannelDataInformationHeaderPart END ########*/
	ETG_TRACE_USR2(("<- parseChannelDataInformationHeaderPart()"));

	return bIsParsingSuccess;
}

tBool fc_usb_tcu_PRC_JSONParser::parseChannelDataInformationRecordPart(Json::Value& jChannelData, T_tcu_channel_data_information& oDest)
{
	ETG_TRACE_USR2(("-> parseChannelDataInformationRecordPart()"));
	tBool bIsParsingSuccess = FALSE;

	//Get ChannelDataInformationRecordPart JSON message
	Json::Value jChannelDataInformationRecordPart;
	bIsParsingSuccess = jsonUtils.getJSONArray(jChannelData, json_utils::CHANNEL_DATA_INFORMATION_RECORD_PART, jChannelDataInformationRecordPart);

	if(bIsParsingSuccess == TRUE)
	{
		//Resize
		oDest.ChannelDataInformationRecordPart.resize(jChannelDataInformationRecordPart.size());

		/*####### ChannelDataInformationRecordPart BEGIN ########*/
		for (tC16 i=0; i < jChannelDataInformationRecordPart.size(); i++)
		{
			bIsParsingSuccess = parseChannelDataInformationRecordItem(jChannelDataInformationRecordPart[i],oDest.ChannelDataInformationRecordPart[i]);
		}
		/*####### ChannelDataInformationRecordPart END ########*/
	}

	ETG_TRACE_USR2(("<- parseChannelDataInformationRecordPart()"));
	return bIsParsingSuccess;
}

tBool fc_usb_tcu_PRC_JSONParser::parseChannelDataInformationRecordItem(Json::Value & jChannelDataInformationRecordPart, T_tcu_channel_data_information_record & oDest)
{
	tBool bIsParsingSuccess = FALSE;

	//Get the channel content type
	tU8 u8ChannelContentType = 0;
	bIsParsingSuccess = jsonUtils.gettU8UInt(jChannelDataInformationRecordPart, json_utils::U8_CHANNEL_CONTENT_TYPE, u8ChannelContentType);

	//Get the channel content ID
	tU8 u8ChannelContentsID = 0;
	if (bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.gettU8UInt(jChannelDataInformationRecordPart, json_utils::U8_CHANNEL_CONTENTS_ID, u8ChannelContentsID);
	}

	//Get the title
	bpstl::string strTitle;
	if (bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.getString(jChannelDataInformationRecordPart, json_utils::STR_TITLE, strTitle);
	}

	//Get the title for TTS
	bpstl::string strTitleForTTS;
	if (bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.getString(jChannelDataInformationRecordPart, json_utils::STR_TITLE_FOR_TTS, strTitleForTTS);
	}

	//Get Location JSON message
	T_tcu_Location oLocation;
	if (bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = parseLocation(jChannelDataInformationRecordPart,oLocation);
	}

	//Get the Location Attribute
	tU8 u8LocationAttribute = 0;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.gettU8UInt(jChannelDataInformationRecordPart, json_utils::U8_LOCATION_ATTRIBUTE, u8LocationAttribute);
	}

	T_e8_tcu_Location_Attribute e8LocationAttribute;
	tU8 u8DestOrWayPointType = 0;
	if(bIsParsingSuccess == TRUE)
	{
		// Set LocationAttribute as ENUM.
		e8LocationAttribute = T_e8_tcu_Location_Attribute::tenType(u8LocationAttribute);

		//Get the Destination Or Way Point Type
		bIsParsingSuccess = jsonUtils.gettU8UInt(jChannelDataInformationRecordPart, json_utils::U8_DEST_OR_WAYPOINT_TYPE, u8DestOrWayPointType);
	}

	T_e8_tcu_Dest_Or_WayPointType e8DestOrWayPointType;
	bpstl::string strAddress;
	if(bIsParsingSuccess == TRUE)
	{
		e8DestOrWayPointType = T_e8_tcu_Dest_Or_WayPointType::tenType(u8DestOrWayPointType);

		//Get the Address
		bIsParsingSuccess = jsonUtils.getString(jChannelDataInformationRecordPart, json_utils::STR_ADDRESS, strAddress);
	}


	//Get the Phone Number
	bpstl::string strPhoneNumber;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.getString(jChannelDataInformationRecordPart, json_utils::STR_PHONE_NUMBER, strPhoneNumber);
	}

	//Get the Phone Number For Display
	bpstl::string strPhoneNumberForDisp;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.getString(jChannelDataInformationRecordPart, json_utils::STR_PHONE_NUMBER_FOR_DISP, strPhoneNumberForDisp);
	}

	//Get the Phone Number For Display
	bpstl::string strMailAddress;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.getString(jChannelDataInformationRecordPart, json_utils::STR_MAIL_ADDRESS, strMailAddress);
	}

	//Get the Phone Number For Display
	bpstl::string strNickname;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.getString(jChannelDataInformationRecordPart, json_utils::STR_NICKNAME, strNickname);
	}

	//Get the Text
	bpstl::string strText;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.getString(jChannelDataInformationRecordPart, json_utils::STR_TEXT, strText);

	}

	//Get the Text For TTS
	bpstl::string strTextForTTS;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.getString(jChannelDataInformationRecordPart, json_utils::STR_TEXT_FOR_TTS, strTextForTTS);
		ETG_TRACE_USR2((" ->strTextForTTS : %s", strTextForTTS.c_str()));
		if(TRUE == bIsParsingSuccess){
		    ETG_TRACE_USR2(("oFactoryInstance "));
		    int u8Region = tcu_usb_fi_tcl_e8_tcu_Regions::FI_EN_REGION_US;

#ifndef VARIANT_S_FTR_ENABLE_UNIT_TEST
		    fc_usb_tcu_factory* oFactoryInstance = fc_usb_tcu_factory::getFactoryInstance();
            FC_USB_TCU_NULL_POINTER_CHECK_VAL(oFactoryInstance);
            u8Region =  oFactoryInstance->eGetRegion().enType;
#endif
            ETG_TRACE_USR2((" region : %d", u8Region));
            if(tcu_usb_fi_tcl_e8_tcu_Regions::FI_EN_REGION_JPN == u8Region){ //apply only for JPN
                //replace your codes here
                strTextForTTS = jsonUtils.processingTTSText(strTextForTTS);
                ETG_TRACE_USR2((" strTextForTTS : %s", strTextForTTS.c_str()));
            }

		}
	}

	//Get the Icon ID
	tU16 u16IconID = 0;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.gettU16UInt(jChannelDataInformationRecordPart, json_utils::U16_ICON_ID, u16IconID);
	}

	//Get the SE Info
	tU16 u16SEInfo = 0;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.gettU16UInt(jChannelDataInformationRecordPart, json_utils::U16_SE_INFO, u16SEInfo);
	}

	//Get the Sound ID For Beginning Of Play
	tU16 u16SoundIDForBeginningOfPlay = 0;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.gettU16UInt(jChannelDataInformationRecordPart, json_utils::U16_SOUNDID_FOR_BEGINNING_OF_PLAY, u16SoundIDForBeginningOfPlay);
	}

	//Get the Sound ID For BGM
	tU16 u16SoundIDForBGM = 0;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.gettU16UInt(jChannelDataInformationRecordPart, json_utils::U16_SOUNDID_FOR_BGM, u16SoundIDForBGM);
	}

	//Get the Action SW ID
	tU8 u8ActionSWID = 0;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.gettU8UInt(jChannelDataInformationRecordPart, json_utils::U8_ACTION_SWID, u8ActionSWID);
	}

	//Get the Parameter Of Action SW
	tU32 u32ParameterOfActionSW = 0;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.gettU32UInt(jChannelDataInformationRecordPart, json_utils::U32_PARAMETEROF_ACTION_SW, u32ParameterOfActionSW);
	}

	//Get the Flag Of Display Button Ctrl
	tU8 u8FlagOfDispButtonCtrl = 0;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.gettU8UInt(jChannelDataInformationRecordPart, json_utils::U8_FLAG_OF_DISP_BUTTON_CTRL, u8FlagOfDispButtonCtrl);
	}

	//Get the Flag Of Ctrl During Running
	tU8 u8FlagOfCtrlDuringRunning = 0;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.gettU8UInt(jChannelDataInformationRecordPart, json_utils::U8_FLAG_OF_CTRL_DURING_RUNNING, u8FlagOfCtrlDuringRunning);
	}

	//Get the Name Of Image Button
	bpstl::string strNameOfImageButton;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.getString(jChannelDataInformationRecordPart, json_utils::STR_NAME_OF_IMAGE_BUTTON, strNameOfImageButton);
	}

	//Get the Name Of Action SW
	bpstl::string strNameOfActionSW = jChannelDataInformationRecordPart.get("strNameOfActionSW", "ERROR").asCString();
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.getString(jChannelDataInformationRecordPart, json_utils::STR_NAME_OF_ACTION_SW, strNameOfActionSW);
	}

	//Get the Flag Of Execution Of Channel Contents
	tU8 u8FlagOfExecOfChannelContents = 0;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.gettU8UInt(jChannelDataInformationRecordPart, json_utils::U8_FLAG_OF_EXEC_OF_CHANNEL_CONTENTS, u8FlagOfExecOfChannelContents);
	}

	//Get the Flag Of Storing Ctrl
	tU8 u8FlagOfStoringCtrl = 0;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.gettU8UInt(jChannelDataInformationRecordPart, json_utils::U8_FLAG_OF_STORING_CTRL, u8FlagOfStoringCtrl);
	}

	//Get the Image Availability
	tU8 u8ImageAvailability = 0;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.gettU8UInt(jChannelDataInformationRecordPart, json_utils::U8_IMAGE_AVAILABILITY, u8ImageAvailability);
	}

	//Get the Image Location
	bpstl::string strImageLocation;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.getString(jChannelDataInformationRecordPart, json_utils::STR_IMAGE_LOCATION, strImageLocation);
	}

	if(bIsParsingSuccess == TRUE)
	{
		T_tcu_channel_data_information_record oChannelDataInformationRecordPart(u8ChannelContentsID,
																			    strTitle,
																			    strTitleForTTS,
																			    oLocation,
																			    e8LocationAttribute,
																			    e8DestOrWayPointType,
																			    strAddress,
																			    strPhoneNumber,
																			    strPhoneNumberForDisp,
																			    strText,
																			    strTextForTTS,
																			    u16IconID,
																			    u16SoundIDForBeginningOfPlay,
																			    u16SoundIDForBGM,
																			    u8ActionSWID,
																			    u32ParameterOfActionSW,
																			    u8FlagOfDispButtonCtrl,
																			    u8FlagOfCtrlDuringRunning,
																			    strNameOfImageButton,
																			    strNameOfActionSW,
																			    u8FlagOfExecOfChannelContents,
																			    u8FlagOfStoringCtrl,
																			    u8ImageAvailability,
																			    strImageLocation,
																			    u8ChannelContentType,
																			    strMailAddress,
																			    strNickname,
																			    u16SEInfo);	/*added for build error*/
		oDest = oChannelDataInformationRecordPart;
	}

	return bIsParsingSuccess;
}

tBool fc_usb_tcu_PRC_JSONParser::parseLocation(Json::Value & jChannelDataInformationRecordPart, T_tcu_Location& oLocation)
{
	ETG_TRACE_USR2(("<< parseChannelDataJSON"));

	Json::Value jLocation;
	tBool bIsParsingSuccess = jsonUtils.getJSONObject(jChannelDataInformationRecordPart, json_utils::LOCATION, jLocation);

	if(bIsParsingSuccess == TRUE)
	{
		//Get the channel content ID
		tU8 u8Direction = 0;
		bIsParsingSuccess = jsonUtils.gettU8UInt(jLocation, json_utils::U8_DIRECTION, u8Direction);

		//Get the Longitude Degree
		tU8 u8Longitude_degree = 0;
		if(bIsParsingSuccess == TRUE)
		{
			bIsParsingSuccess = jsonUtils.gettU8UInt(jLocation, json_utils::U8_LONGITUDE_DEGREE, u8Longitude_degree);
		}

		//Get the Longitude minute
		tU8 u8Longitude_minute = 0;
		if(bIsParsingSuccess == TRUE)
		{
			bIsParsingSuccess = jsonUtils.gettU8UInt(jLocation, json_utils::U8_LONGITUDE_MINUTE, u8Longitude_minute);
		}

		//Get the Longitude second
		tU16 u16Longitude_second = 0;
		if(bIsParsingSuccess == TRUE)
		{
			bIsParsingSuccess = jsonUtils.gettU16UInt(jLocation, json_utils::U16_LONGITUDE_SECOND, u16Longitude_second);
		}
		//Get the Latitude degree
		tU8 u8Latitude_degree = 0;
		if(bIsParsingSuccess == TRUE)
		{
			bIsParsingSuccess = jsonUtils.gettU8UInt(jLocation, json_utils::U8_LATITUDE_DEGREE, u8Latitude_degree);
		}

		//Get the Latitude minute
		tU8 u8Latitude_minute = 0;
		if(bIsParsingSuccess == TRUE)
		{
			bIsParsingSuccess = jsonUtils.gettU8UInt(jLocation, json_utils::U8_LATITUDE_MINUTE, u8Latitude_minute);
		}

		//Get the Latitude second
		tU16 u16Latitude_second = 0;
		if(bIsParsingSuccess == TRUE)
		{
			bIsParsingSuccess = jsonUtils.gettU16UInt(jLocation, json_utils::U16_LATITUDE_SECOND, u16Latitude_second);
		}

		if(bIsParsingSuccess == TRUE)
		{
			T_tcu_Location tempoLocation(u8Direction,
										 u8Longitude_degree,
										 u8Longitude_minute,
										 u16Longitude_second,
										 u8Latitude_degree,
										 u8Latitude_minute,
										 u16Latitude_second);
			oLocation = tempoLocation;
		}
	}

	ETG_TRACE_USR2(("<< parseLocation"));
	return bIsParsingSuccess;
}

tBool fc_usb_tcu_PRC_JSONParser::parseExecutionInformation(Json::Value & jChannelDataInformationRecordPart,T_tcu_Exection_Information& oExecutionInformation)
{
	ETG_TRACE_USR2(("<< parseExecutionInformation"));
	tBool bIsParsingSuccess = FALSE;

	/*####### ExecutionInformation BEGIN ########*/

	//Get ExecutionInformation JSON message
	Json::Value jExecutionInformation;
	bIsParsingSuccess = jsonUtils.getJSONObject(jChannelDataInformationRecordPart, json_utils::EXECUTION_INFORMATION, jExecutionInformation);

	//Get the Execution type
	tU8 u8ExecType = 0;
	T_e8_tcu_ExecType e8ExecType;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.gettU8UInt(jExecutionInformation, json_utils::U8_EXEC_TYPE, u8ExecType);
	}

	Json::Value jExectionDetails;
	if(bIsParsingSuccess == TRUE)
	{
		// Set u8ExecType as ENUM.
		e8ExecType = T_e8_tcu_ExecType::tenType(u8ExecType);

		//Get ExectionDetails JSON message
		bIsParsingSuccess = jsonUtils.getJSONObject(jExecutionInformation, json_utils::EXECTION_DETAILS, jExectionDetails);
	}

	//Get RouteCalc JSON message
	Json::Value jRouteCalc;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.getJSONObject(jExectionDetails, json_utils::ROUTE_CALC, jRouteCalc);
	}

	/*####### RouteCalc BEGIN ########*/
	T_tcu_Route_Calc oRouteCalc;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = parseRouteCalc(jRouteCalc,oRouteCalc);
	}
	/*####### RouteCalc END ########*/

	Json::Value jCall;
	/* if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.getJSONObject(jExectionDetails, json_utils::EXEC_TYPE_CALL, jCall);
	}
 */
	/*####### Call BEGIN ########*/
	T_tcu_Call oCall;
	/* if(bIsParsingSuccess == TRUE) {
		bIsParsingSuccess = parseCall(jCall,oCall);
	} */
	/*####### Call END ########*/

	//Get DispList JSON message
	Json::Value jDispList;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.getJSONObject(jExectionDetails, json_utils::DISPLIST, jDispList);
	}

	/*####### DispList BEGIN ########*/
	T_tcu_Disp_List oDispList;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = parseDispList(jDispList,oDispList);
	}
	/*####### DispList END ########*/

	//Get AutoPlay JSON message
	Json::Value jAutoPlay;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.getJSONObject(jExectionDetails, json_utils::AUTO_PLAY, jAutoPlay);

	}

	/*####### AutoPlay BEGIN ########*/
	T_tcu_Auto_Play oAutoPlay;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = parseAutoPlay(jAutoPlay,oAutoPlay);
	}
	/*####### AutoPlay END ########*/

	Json::Value jAutoDJExec;
	/* if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.getJSONObject(jExectionDetails, json_utils::EXEC_TYPE_AUTODJ_EXEC, jAutoDJExec);
	} */

	/*####### AutoDJExec BEGIN ########*/
	T_tcu_AutoDJ_Exec oAutoDJExec;
	/* if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = parseAutoDJExec(jAutoDJExec,oAutoDJExec);
	} */
	/*####### AutoDJExec END ########*/


	Json::Value jOperatorCall;
	/* if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.getJSONObject(jExectionDetails, json_utils::EXEC_TYPE_OPERATOR_CALL, jOperatorCall);
	} */

	/*####### AutoDJExec BEGIN ########*/
	T_tcu_Operator_Call oOperatorCall;
	/* if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = parseOperatorCall(jOperatorCall,oOperatorCall);
	} */
	/*####### AutoDJExec END ########*/

	Json::Value jAutoPlayWithMappoint;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.getJSONObject(jExectionDetails, json_utils::EXEC_TYPE_AUTOPLAY_WITH_MAPPOINT, jAutoPlayWithMappoint);
	}

	/*####### AutoPlay with Mappoint BEGIN ########*/
	T_tcu_AutoPlay_with_Mappoint oAutoPlayWithMappoint;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = parseAutoPlayWithMappoint(jAutoPlayWithMappoint,oAutoPlayWithMappoint);
	}
	/*####### AutoPlay with Mappoint END ########*/


	if(bIsParsingSuccess == TRUE)
	{
		T_tcu_CW_Setting CWSetting ;
		T_tcu_Detail_Of_Execution oExectionDetails(oRouteCalc,
												   oDispList,
												   oAutoPlay,
												   oCall,
												   CWSetting,
												   oAutoDJExec,
												   oOperatorCall,
												   oAutoPlayWithMappoint);

		T_tcu_Exection_Information tempExecutionInformation(e8ExecType, oExectionDetails);
		oExecutionInformation = tempExecutionInformation;
	}


	/*####### ExecutionInformation END ########*/

	ETG_TRACE_USR3(("<< parseExecutionInformation"));
	return bIsParsingSuccess;
}

tBool fc_usb_tcu_PRC_JSONParser::parseRouteCalc(Json::Value jRouteCalc, T_tcu_Route_Calc& oRouteCalc)
{
	ETG_TRACE_USR2(("<< parseRouteCalc"));
	tBool bIsParsingSuccess = FALSE;

	//Get the Section Type
	tU8 u8SectionType = 0;
	T_e8_tcu_section_type eSectionType;
	bIsParsingSuccess = jsonUtils.gettU8UInt(jRouteCalc, json_utils::SECTION_TYPE, u8SectionType);


	tU8 Condition_Of_RouteCalc_all_section_or_section_1 = 0;
	T_e8_tcu_Condition_Of_Route_Calc eCondition_Of_RouteCalc_all_section_or_section_1;
	if(bIsParsingSuccess)
	{
		// Set u8SectionType as ENUM.
		eSectionType = T_e8_tcu_section_type::tenType(u8SectionType);

		//Get the Condition_Of_RouteCalc_all_section_or_section_1
		bIsParsingSuccess = jsonUtils.gettU8UInt(jRouteCalc, json_utils::CONDITION_OF_ROUTECALC_ALL_SECTION_OR_SECTION_1, Condition_Of_RouteCalc_all_section_or_section_1);
	}

	tU8 Condition_Of_Route_Calc_section_2 = 0;
	T_e8_tcu_Condition_Of_Route_Calc eCondition_Of_Route_Calc_section_2;
	if(bIsParsingSuccess == TRUE)
	{
		// Set u8SectionType as ENUM.
		 eCondition_Of_RouteCalc_all_section_or_section_1 = T_e8_tcu_Condition_Of_Route_Calc::tenType(Condition_Of_RouteCalc_all_section_or_section_1);

		//Get the Condition_Of_Route_Calc_section_2
		bIsParsingSuccess = jsonUtils.gettU8UInt(jRouteCalc, json_utils::CONDITION_OF_ROUTE_CALC_SECTION_2, Condition_Of_Route_Calc_section_2);
	}

	tU8 Condition_Of_Route_Calc_section_3 = 0;
	T_e8_tcu_Condition_Of_Route_Calc eCondition_Of_Route_Calc_section_3;
	if(bIsParsingSuccess == TRUE)
	{
		// Set u8SectionType as ENUM.
		eCondition_Of_Route_Calc_section_2 = T_e8_tcu_Condition_Of_Route_Calc::tenType(Condition_Of_Route_Calc_section_2);

		//Get the Condition_Of_Route_Calc_section_3
		bIsParsingSuccess = jsonUtils.gettU8UInt(jRouteCalc, json_utils::CONDITION_OF_ROUTE_CALC_SECTION_3, Condition_Of_Route_Calc_section_3);
	}

	tU8 Condition_Of_Route_Calc_section_4 = 0;
	T_e8_tcu_Condition_Of_Route_Calc eCondition_Of_Route_Calc_section_4;
	if(bIsParsingSuccess == TRUE)
	{
		// Set u8SectionType as ENUM.
		eCondition_Of_Route_Calc_section_3 = T_e8_tcu_Condition_Of_Route_Calc::tenType(Condition_Of_Route_Calc_section_3);

		//Get the Condition_Of_Route_Calc_section_4
		bIsParsingSuccess = jsonUtils.gettU8UInt(jRouteCalc, json_utils::CONDITION_OF_ROUTE_CALC_SECTION_4, Condition_Of_Route_Calc_section_4);
	}

	tU8 Condition_Of_Route_Calc_section_5 = 0;
	T_e8_tcu_Condition_Of_Route_Calc eCondition_Of_Route_Calc_section_5;
	if(bIsParsingSuccess == TRUE)
	{
		// Set u8SectionType as ENUM.
		eCondition_Of_Route_Calc_section_4 = T_e8_tcu_Condition_Of_Route_Calc::tenType(Condition_Of_Route_Calc_section_4);

		//Get the Condition_Of_Route_Calc_section_5
		bIsParsingSuccess = jsonUtils.gettU8UInt(jRouteCalc, json_utils::CONDITION_OF_ROUTE_CALC_SECTION_5, Condition_Of_Route_Calc_section_5);
	}

	tU8 Condition_Of_Route_Calc_section_6 = 0;
	T_e8_tcu_Condition_Of_Route_Calc eCondition_Of_Route_Calc_section_6;
	if(bIsParsingSuccess == TRUE)
	{
		// Set u8SectionType as ENUM.
		eCondition_Of_Route_Calc_section_5 = T_e8_tcu_Condition_Of_Route_Calc::tenType(Condition_Of_Route_Calc_section_5);

		//Get the Condition_Of_Route_Calc_section_6
		bIsParsingSuccess = jsonUtils.gettU8UInt(jRouteCalc, json_utils::CONDITION_OF_ROUTE_CALC_SECTION_6, Condition_Of_Route_Calc_section_6);
	}

	tU16 u16VICS_RTIC_setting = 0;
	if(bIsParsingSuccess == TRUE)
	{
		// Set u8SectionType as ENUM.
		eCondition_Of_Route_Calc_section_6 = T_e8_tcu_Condition_Of_Route_Calc::tenType(Condition_Of_Route_Calc_section_6);
		bIsParsingSuccess = jsonUtils.gettU16UInt(jRouteCalc, json_utils::U16_VICS_RTIC_SETTING, u16VICS_RTIC_setting);
	}

	if(bIsParsingSuccess == TRUE)
	{
		T_tcu_Route_Calc tempRouteCalc(eSectionType,
									   eCondition_Of_RouteCalc_all_section_or_section_1,
									   eCondition_Of_Route_Calc_section_2,
									   eCondition_Of_Route_Calc_section_3,
									   eCondition_Of_Route_Calc_section_4,
									   eCondition_Of_Route_Calc_section_5,
									   eCondition_Of_Route_Calc_section_6,
									   u16VICS_RTIC_setting);
		oRouteCalc = tempRouteCalc;
	}

	ETG_TRACE_USR3(("<< parseRouteCalc"));
	return bIsParsingSuccess;
}

tBool fc_usb_tcu_PRC_JSONParser::parseCall(Json::Value jCall, T_tcu_Call& oCall)
{
	ETG_TRACE_USR2(("<< parseCall"));
	tBool bIsParsingSuccess = FALSE;

	//Get the Number Of Channel Contents
	tU8 u8ChannelContentsID = 0;
	bIsParsingSuccess = jsonUtils.gettU8UInt(jCall, json_utils::U8_CHANNEL_CONTENT_ID, u8ChannelContentsID);

	if(bIsParsingSuccess == TRUE)
	{
		oCall.u8ChannelContentID = u8ChannelContentsID;
	}

	ETG_TRACE_USR3((">> parseCall"));
	return bIsParsingSuccess;
}

tBool fc_usb_tcu_PRC_JSONParser::parseAutoPlay(Json::Value jAutoPlay, T_tcu_Auto_Play& oAutoPlay)
{
	ETG_TRACE_USR2(("<< parseAutoPlay"));
	tBool bIsParsingSuccess = FALSE;

	//Get the Number Of Channel Contents
	tU8 u8Num_Of_Channel_Contents = 0;
	bIsParsingSuccess = jsonUtils.gettU8UInt(jAutoPlay, json_utils::AUTO_PLAY_U8_NUM_OF_CHANNEL_CONTENTS, u8Num_Of_Channel_Contents);

	Json::Value jChannelContentsList;
	if(bIsParsingSuccess == TRUE)
	{
		oAutoPlay.u8Num_Of_Channel_Contents = u8Num_Of_Channel_Contents;

		//Get the Channel Contents ID
		bIsParsingSuccess = jsonUtils.getJSONArray(jAutoPlay, json_utils::CHANNEL_CONTENTS_ID, jChannelContentsList);
	}


	if(bIsParsingSuccess == TRUE)
	{
		//Resize
		oAutoPlay.u8ChannelContentsID.resize(jChannelContentsList.size());
		for (tC16 i=0; i < jChannelContentsList.size(); ++i)
		{
			tU8 u8ChannelContentID = jChannelContentsList[i].asUInt();
			oAutoPlay.u8ChannelContentsID[i] = u8ChannelContentID;
		}
	}

	ETG_TRACE_USR3(("<< parseAutoPlay"));
	return bIsParsingSuccess;
}

tBool fc_usb_tcu_PRC_JSONParser::parseAutoDJExec(Json::Value jAutoDJExec, T_tcu_AutoDJ_Exec& oAutoDJExec)
{
	ETG_TRACE_USR2(("<< parseDispList"));
	tBool bIsParsingSuccess = FALSE;

	//Get the Number Of Channel Contents
	tU8 u8NumOfTargetAutoDJChannelNo = 0;
	bIsParsingSuccess = jsonUtils.gettU8UInt(jAutoDJExec, json_utils::U8_NUM_OF_TARGET_AUTODJ_CHANNELNO, u8NumOfTargetAutoDJChannelNo);

	Json::Value jTargetAutoDJChannelNoList;
	if(bIsParsingSuccess == TRUE)
	{
		oAutoDJExec.u8NumOfTargetAutoDJChannelNo = u8NumOfTargetAutoDJChannelNo;

		//Get the Channel Contents ID
		bIsParsingSuccess = jsonUtils.getJSONArray(jAutoDJExec, json_utils::U16_LIST_OF_TARGET_AUTODJ_CHANNELNO, jTargetAutoDJChannelNoList);
	}

	if(bIsParsingSuccess == TRUE)
	{
		//Resize
		oAutoDJExec.u16TargetAutoDJChannelNo.resize(jTargetAutoDJChannelNoList.size());

		for (tC16 k=0; k < jTargetAutoDJChannelNoList.size(); ++k)
		{
			tU16 u16TargetAutoDJChannelNo = jTargetAutoDJChannelNoList[k].asUInt();
			oAutoDJExec.u16TargetAutoDJChannelNo[k] = u16TargetAutoDJChannelNo;
		}
	}

	return bIsParsingSuccess;
}

tBool fc_usb_tcu_PRC_JSONParser::parseDispList(Json::Value jDispList, T_tcu_Disp_List& oDispList)
{

	ETG_TRACE_USR2(("<< parseDispList"));
	tBool bIsParsingSuccess = FALSE;

	//Get the Number Of Channel Contents
	tU8 u8NumOfChannelContents = 0;
	bIsParsingSuccess = jsonUtils.gettU8UInt(jDispList, json_utils::NUM_OF_CHANNEL_CONTENTS, u8NumOfChannelContents);

	Json::Value jChannelContentsList;
	if(bIsParsingSuccess == TRUE)
	{
		oDispList.u8NumOfChannelContents = u8NumOfChannelContents;

		//Get the Channel Contents ID
		bIsParsingSuccess = jsonUtils.getJSONArray(jDispList, json_utils::CHANNEL_CONTENTS_ID, jChannelContentsList);
	}

	if(bIsParsingSuccess == TRUE)
	{
		//Resize
		oDispList.u8ChannelContentsID.resize(jChannelContentsList.size());

		for (tC16 k=0; k < jChannelContentsList.size(); ++k)
		{
			tU8 u8ChannelContentID = jChannelContentsList[k].asUInt();
			oDispList.u8ChannelContentsID[k] = u8ChannelContentID;
		}
	}

	ETG_TRACE_USR3(("<< parseDispList"));
	return bIsParsingSuccess;
}

tBool fc_usb_tcu_PRC_JSONParser::parseOperatorCall(Json::Value jOperatorCall, T_tcu_Operator_Call& oOperatorCall)
{
	ETG_TRACE_USR2(("<< parseOperatorCall"));
	tBool bIsParsingSuccess = FALSE;

	//Get the Number Of Channel Contents
	tU8 u8ChannelContentsID = 0;
	bIsParsingSuccess = jsonUtils.gettU8UInt(jOperatorCall, json_utils::U8_CHANNEL_CONTENTS_ID, u8ChannelContentsID);

	if(bIsParsingSuccess == TRUE)
	{
		oOperatorCall.u8ChannelContentID = u8ChannelContentsID;
	}

	ETG_TRACE_USR3((">> parseOperatorCall"));
	return bIsParsingSuccess;
}

tBool fc_usb_tcu_PRC_JSONParser::parseAutoPlayWithMappoint(Json::Value jAutoPlayWithMappoint, T_tcu_AutoPlay_with_Mappoint& oAutoPlayWithMappoint)
{
	ETG_TRACE_USR2(("<< parseAutoPlayWithMappoint"));
	tBool bIsParsingSuccess = FALSE;

	//Get the Location to Display
	tU8 u8LocationToDisplay = 0;
	bIsParsingSuccess = jsonUtils.gettU8UInt(jAutoPlayWithMappoint, json_utils::U8_LOCATION_TO_DISPLAY, u8LocationToDisplay);

	//Get the Map display scale.
	tU8 u8MapDisplayScale = 0;
	if(bIsParsingSuccess == TRUE) {
		oAutoPlayWithMappoint.u8LocationToDisplay =  T_e8_tcu_Location_to_Display::tenType(u8LocationToDisplay);
		bIsParsingSuccess = jsonUtils.gettU8UInt(jAutoPlayWithMappoint, json_utils::U8_MAP_DISPLAY_SCALE, u8MapDisplayScale);
	}

	//Get the Number Of Channel Contents
	tU8 u8NumOfChannelContents = 0;
	if(bIsParsingSuccess == TRUE) {
		oAutoPlayWithMappoint.u8MapDisplayScale = T_e8_tcu_Map_Display_Scale::tenType(u8MapDisplayScale);
		bIsParsingSuccess = jsonUtils.gettU8UInt(jAutoPlayWithMappoint, json_utils::U8_NUM_OF_CHANNEL_CONTENTS, u8NumOfChannelContents);
	}


	Json::Value jChannelContentsList;
	if(bIsParsingSuccess == TRUE)
	{
		oAutoPlayWithMappoint.u8NumOfChannelContents = u8NumOfChannelContents;

		//Get the Channel Contents ID
		bIsParsingSuccess = jsonUtils.getJSONArray(jAutoPlayWithMappoint, json_utils::U8_LIST_OF_CHANNEL_CONTENTS, jChannelContentsList);
	}


	if(bIsParsingSuccess == TRUE)
	{
		//Resize
		oAutoPlayWithMappoint.u8ChannelContentsID.resize(jChannelContentsList.size());
		for (tC16 i=0; i < jChannelContentsList.size(); ++i)
		{
			tU8 u8ChannelContentID = jChannelContentsList[i].asUInt();
			oAutoPlayWithMappoint.u8ChannelContentsID[i] = u8ChannelContentID;
		}
	}

	ETG_TRACE_USR3((">> parseAutoPlayWithMappoint"));
	return bIsParsingSuccess;
}

/******************************************** PARSE CHANNEL MASTER DATA *************************************************************************/

tBool fc_usb_tcu_PRC_JSONParser::vParseChannelMasterDataJSON(Json::Value& root, T_tcu_channel_master_data_result& oChannelMasterData)
{
	ETG_TRACE_USR2(("<< parseChannelMasterDataJSON"));

	tBool bIsParsingSuccess = false;

	//Get ChannelMasterData JSON message
	Json::Value jCMD;
	bIsParsingSuccess = jsonUtils.getJSONObject(root, json_utils::CHANNEL_MASTER_DATA, jCMD);

	if (bIsParsingSuccess)
	{
		bIsParsingSuccess = parseChannelMasterDataFileHeader(jCMD, oChannelMasterData);
	
	}
	//not check return success

	if (bIsParsingSuccess)
	{
		bIsParsingSuccess = parseChannelMasterDataHeader(jCMD, oChannelMasterData);
		if(bIsParsingSuccess){
			bIsParsingSuccess = parseFolderDefinitionInformation(jCMD, oChannelMasterData);
		}
		if(bIsParsingSuccess){
			bIsParsingSuccess = parseChannelDefinitionInformation(jCMD, oChannelMasterData);
		}
	}

	/*ToDo: These null checks can be removed by creating a parameterized constructor with m_poUsbTcu. Mani Arjunan*/
	if (!bIsParsingSuccess)
	{
		ETG_TRACE_USR2(("Parsing JSON FAILED!!"));
	}

	return bIsParsingSuccess;


}


tBool fc_usb_tcu_PRC_JSONParser::parseChannelMasterDataFileHeader(Json::Value & jCMD, T_tcu_channel_master_data_result & oChannelMasterData){
	ETG_TRACE_USR2(("<< parseChannelMasterDataFileHeader"));

	tBool bIsParsingSuccess = false;
	Json::Value jCMDFileHeader;
	bIsParsingSuccess = jsonUtils.getJSONObject(jCMD, json_utils::FILE_HEADER, jCMDFileHeader);
	if (!bIsParsingSuccess) {
		ETG_TRACE_ERR(("Parsing FileHeader date FAILED!!"));
		return bIsParsingSuccess;
	}
//Get Expiration date.
	Json::Value jExpirationDate;
	bIsParsingSuccess = jsonUtils.getJSONObject(jCMDFileHeader, json_utils::EXPIRY_DATE, jExpirationDate);

	if (!bIsParsingSuccess) {
		ETG_TRACE_ERR(("Parsing Expiration date FAILED!!"));
		return bIsParsingSuccess;
	}

	T_tcu_carwings_date ExpirationDate;
	bIsParsingSuccess = bParseCarwingsDate(jExpirationDate, ExpirationDate);
	if (!bIsParsingSuccess) {
		ETG_TRACE_ERR(("ParseCarwingsDate Expiration date FAILED!!"));
		return bIsParsingSuccess;
	}
	ETG_TRACE_USR2(("<< ExpirationDate"));
	oChannelMasterData.ChannelMasterData.FileHeaderA.ExpiryDate = ExpirationDate;

	ETG_TRACE_USR2((">> parseChannelMasterDataFileHeader "));
	return bIsParsingSuccess;

}

tBool fc_usb_tcu_PRC_JSONParser::parseChannelMasterDataHeader(Json::Value & jCMD, T_tcu_channel_master_data_result & oChannelMasterData)
{
	ETG_TRACE_USR2(("<< parseChannelMasterDataHeader"));

	tBool bIsParsingSuccess = false;
    Json::Value jCMDHeader;
    tBool boolGetCMDHeaderJSONObj = jsonUtils.getJSONObject(jCMD, json_utils::CHANNEL_CMD_HEADER, jCMDHeader);

    if (boolGetCMDHeaderJSONObj)
    {
		//Get the number of Folder definition info.
		tU8 u8NumOfFolderDefInfo;
		bIsParsingSuccess = jsonUtils.gettU8UInt(jCMDHeader, json_utils::U8_NUM_OF_FOLDER_DEF_INFO, u8NumOfFolderDefInfo);
		if (bIsParsingSuccess)
		{
			oChannelMasterData.ChannelMasterData.ChannelMasterDataHeader.u8NumOfFolderDefInfo = u8NumOfFolderDefInfo;
		}

		//Get the number of Channel definition info.
		tU16 u16NumOfChannelDefInfo;
		bIsParsingSuccess = jsonUtils.gettU16UInt(jCMDHeader, json_utils::U16_NUM_OF_CHANNEL_DEF_INFO, u16NumOfChannelDefInfo);
		if (bIsParsingSuccess)
		{
			oChannelMasterData.ChannelMasterData.ChannelMasterDataHeader.u16NumOfChannelDefInfo = u16NumOfChannelDefInfo;
		}
	}

    return bIsParsingSuccess;
}

tBool fc_usb_tcu_PRC_JSONParser::parseFolderDefinitionInformation(Json::Value & jCMD, T_tcu_channel_master_data_result & oChannelMasterData)
{
	ETG_TRACE_USR2(("<< parseFolderDefinitionInformation"));
	tBool bIsParsingSuccess = false;

    Json::Value jFolderDefinitionInformation;
    bIsParsingSuccess = jsonUtils.getJSONArray(jCMD, json_utils::FOLDER_DEFINITION_INFORMATION, jFolderDefinitionInformation);
    if (bIsParsingSuccess)
    {
		//Resize
		oChannelMasterData.ChannelMasterData.FolderDefinitionInformation.resize(jFolderDefinitionInformation.size());

		//Update the Folder definition Information for each Folder
		for (tC16 i = 0; i < jFolderDefinitionInformation.size(); i++)
		{

			// Get FolderID
			tU16 u16FolderID;
			bIsParsingSuccess = jsonUtils.gettU16UInt(jFolderDefinitionInformation[i],json_utils::U16_FOLDER_ID, u16FolderID);
			ETG_TRACE_USR2(("<< Parsing u16FolderID  object"));
			if (bIsParsingSuccess)
			{
				oChannelMasterData.ChannelMasterData.FolderDefinitionInformation[i].u16FolderID = u16FolderID;
			}
			else
			{
				ETG_TRACE_USR2(("Parsing FolderID FAILED!!"));
			}

			// Get FolderName
			bpstl::string strFolderName;
			bIsParsingSuccess = jsonUtils.getString(jFolderDefinitionInformation[i], json_utils::STR_FOLDER_NAME, strFolderName);
			ETG_TRACE_USR2(("<< Parsing strFolderName  object"));
			if (bIsParsingSuccess)
			{
				oChannelMasterData.ChannelMasterData.FolderDefinitionInformation[i].strFolderName = strFolderName;
			}
			else
			{
				ETG_TRACE_USR2(("Parsing FolderName FAILED!!"));
			}

			// Get FolderName
			bpstl::string strFolderNameForTTS;
			bIsParsingSuccess = jsonUtils.getString(jFolderDefinitionInformation[i], json_utils::STR_FOLDER_NAME_FOR_TTS, strFolderNameForTTS);
			ETG_TRACE_USR2(("<< Parsing strFolderName  object"));
			if (bIsParsingSuccess)
			{
				oChannelMasterData.ChannelMasterData.FolderDefinitionInformation[i].strFolderNameForTTS = strFolderNameForTTS;
			}
			else
			{
				ETG_TRACE_USR2(("Parsing FolderName FAILED!!"));
			}

			tU16 u16FolderIconID;
			bIsParsingSuccess = jsonUtils.gettU16UInt(jFolderDefinitionInformation[i], json_utils::U16_FOLDER_ICON_ID, u16FolderIconID);
			ETG_TRACE_USR2(("<< Parsing u16FolderIconID  object"));
			if (bIsParsingSuccess)
			{
				oChannelMasterData.ChannelMasterData.FolderDefinitionInformation[i].u16FolderIconID = u16FolderIconID;
			}
			else
			{
				ETG_TRACE_USR2(("Parsing FolderIconID FAILED!!"));
			}

			tU8 u8MovingRestrictionFlagCtrl = 0;
			bIsParsingSuccess= jsonUtils.gettU8UInt(jFolderDefinitionInformation[i], json_utils::U8_MOVING_RESTRICTION_FLAG_CTRL, u8MovingRestrictionFlagCtrl);
			ETG_TRACE_USR2(("<< Parsing u16FolderIconID  object"));
			if (bIsParsingSuccess)
			{
				oChannelMasterData.ChannelMasterData.FolderDefinitionInformation[i].u8CtrlFlagForMovingRestrictionDisplayFolder = T_e8_tcu_CtrlFlagForMovingRestriction::tenType(u8MovingRestrictionFlagCtrl);
			}
			else
			{
				ETG_TRACE_USR2(("Parsing u8MovingRestrictionFlagCtrl FAILED!!"));
			}
		}
	}
    else
    {
		ETG_TRACE_USR2(("Parsing FolderDefinitionInformation FAILED!!"));
	}

    return bIsParsingSuccess;
}

tBool fc_usb_tcu_PRC_JSONParser::parseChannelDefinitionInformation(Json::Value & jCMD, T_tcu_channel_master_data_result & oChannelMasterData)
{
	ETG_TRACE_USR2(("<< parseChannelDefinitionInformation"));
	tBool bIsParsingSuccess = false;

    Json::Value jChannelDefinitionInformation;
    bIsParsingSuccess = jsonUtils.getJSONArray(jCMD, json_utils::CHANNEL_DEFINITION_INFORMATION, jChannelDefinitionInformation);
    if (!bIsParsingSuccess) {
    	ETG_TRACE_ERR(("Parsing ChannelDefinitionInformation FAILED!!"));
		return bIsParsingSuccess;
	}

	//Resize
	oChannelMasterData.ChannelMasterData.ChannelDefinitionInformation.resize(jChannelDefinitionInformation.size());

	//Update the Channel definition Information for each Folder
	for (tC16 i = 0; i < jChannelDefinitionInformation.size(); i++)
	{

		// Get ChannelID
		tU16 u16ChannelID;
		bIsParsingSuccess = jsonUtils.gettU16UInt(jChannelDefinitionInformation[i],json_utils::U16_CHANNEL_ID, u16ChannelID);

		if (!bIsParsingSuccess) {
			ETG_TRACE_ERR(("Parsing ChannelID FAILED!!"));
			return bIsParsingSuccess;
		}
		oChannelMasterData.ChannelMasterData.ChannelDefinitionInformation[i].u16ChannelID = u16ChannelID;

		// Get ChannelName
		bpstl::string strChannelName;
		bIsParsingSuccess = jsonUtils.getString(jChannelDefinitionInformation[i], json_utils::STR_CHANNEL_NAME, strChannelName);

		if (!bIsParsingSuccess) {
			ETG_TRACE_ERR(("Parsing ChannelName FAILED!!"));
			return bIsParsingSuccess;
		}
		oChannelMasterData.ChannelMasterData.ChannelDefinitionInformation[i].strChannelName = strChannelName;

		// Get ChannelName For TTS
		bpstl::string strChannelNameForTTS;
		bIsParsingSuccess = jsonUtils.getString(jChannelDefinitionInformation[i], json_utils::STR_CHANNEL_NAME_FOR_TTS, strChannelNameForTTS);

		if (!bIsParsingSuccess) {
			ETG_TRACE_ERR(("Parsing ChannelName FAILED!!"));
			return bIsParsingSuccess;
		}
		oChannelMasterData.ChannelMasterData.ChannelDefinitionInformation[i].strChannelNameForTTS = strChannelNameForTTS;

		// Get Menu control flag.
		tU8 u8MenuCtrlFlag;
		bIsParsingSuccess = jsonUtils.gettU8UInt(jChannelDefinitionInformation[i], json_utils::U8_MENU_CTRL_FLAG, u8MenuCtrlFlag);

		if (!bIsParsingSuccess) {
			ETG_TRACE_ERR(("Parsing Menu control flag FAILED!!"));
			return bIsParsingSuccess;
		}
		oChannelMasterData.ChannelMasterData.ChannelDefinitionInformation[i].u8FlagOfMenuCtrl = u8MenuCtrlFlag;

		// Get Channel generation mode id.
		tU8 u8ChannelGenModeID;
		bIsParsingSuccess = jsonUtils.gettU8UInt(jChannelDefinitionInformation[i], json_utils::U8_CHANNEL_GEN_MODE_ID, u8ChannelGenModeID);

		if (!bIsParsingSuccess) {
			ETG_TRACE_ERR(("Parsing Channel generation mode id FAILED!!"));
			return bIsParsingSuccess;
		}
		oChannelMasterData.ChannelMasterData.ChannelDefinitionInformation[i].u8ChannelGenModeID = T_e8_tcu_ChannelGenModeID::tenType(u8ChannelGenModeID);

		// Get Distribution start date.
		Json::Value jDistributionStartDate;
		bIsParsingSuccess = jsonUtils.getJSONObject(jChannelDefinitionInformation[i], json_utils::DISTRIBUTION_STARTDATE, jDistributionStartDate);

		if (!bIsParsingSuccess) {
			ETG_TRACE_ERR(("Parsing Distribution start date FAILED!!"));
			return bIsParsingSuccess;
		}

		T_tcu_carwings_date DistributionStartDate;
		bIsParsingSuccess = bParseCarwingsDate(jDistributionStartDate, DistributionStartDate);
		if (!bIsParsingSuccess) {
			ETG_TRACE_ERR(("Parsing Distribution start date FAILED!!"));
			return bIsParsingSuccess;
		}
		oChannelMasterData.ChannelMasterData.ChannelDefinitionInformation[i].DistributionStartDate = DistributionStartDate;

		// Get Distribution end date.
		Json::Value jDistributionEndDate;
		bIsParsingSuccess = jsonUtils.getJSONObject(jChannelDefinitionInformation[i], json_utils::DISTRIBUTION_ENDDATE, jDistributionEndDate);

		if (!bIsParsingSuccess) {
			ETG_TRACE_ERR(("Parsing Distribution end date FAILED!!"));
			return bIsParsingSuccess;
		}

		T_tcu_carwings_date DistributionEndDate;
		bIsParsingSuccess = bParseCarwingsDate(jDistributionEndDate, DistributionEndDate);
		if (!bIsParsingSuccess) {
			ETG_TRACE_ERR(("Parsing Distribution end date FAILED!!"));
			return bIsParsingSuccess;
		}
		oChannelMasterData.ChannelMasterData.ChannelDefinitionInformation[i].DistributionEndDate = DistributionEndDate;

		// Get Channel Flag.
		tU8 u8ChannelFlag;
		bIsParsingSuccess = jsonUtils.gettU8UInt(jChannelDefinitionInformation[i], json_utils::U8_CHANNEL_FLAG, u8ChannelFlag);

		if (!bIsParsingSuccess) {
			ETG_TRACE_ERR(("Parsing Channel Flag FAILED!!"));
			return bIsParsingSuccess;
		}
		oChannelMasterData.ChannelMasterData.ChannelDefinitionInformation[i].u8ChannelFlag = u8ChannelFlag;


		// Get Button display control flag.
		tU8 u8BtnDisplayCtrlFlag;
		bIsParsingSuccess = jsonUtils.gettU8UInt(jChannelDefinitionInformation[i], json_utils::U8_BTN_DISPLAY_CTRL_FLAG, u8BtnDisplayCtrlFlag);
		if (!bIsParsingSuccess) {
			ETG_TRACE_ERR(("Parsing Button display control flag FAILED!!"));
			return bIsParsingSuccess;
		}
		oChannelMasterData.ChannelMasterData.ChannelDefinitionInformation[i].u8BtnDisplayCtrlFlag = u8BtnDisplayCtrlFlag;

		tU8 u8MovingRestrictionFlagCtrl = 0;
		bIsParsingSuccess= jsonUtils.gettU8UInt(jChannelDefinitionInformation[i], json_utils::U8_MOVING_RESTRICTION_FLAG_CTRL, u8MovingRestrictionFlagCtrl);
		if (!bIsParsingSuccess) {
			ETG_TRACE_ERR(("Parsing u8MovingRestrictionFlagCtrl FAILED!!"));
			return bIsParsingSuccess;
		}
		oChannelMasterData.ChannelMasterData.ChannelDefinitionInformation[i].u8CtrlFlagForMovingRestriction = u8MovingRestrictionFlagCtrl;

		tU8 u8NumberOfDataContentsPerOnce = 0;
		bIsParsingSuccess= jsonUtils.gettU8UInt(jChannelDefinitionInformation[i], json_utils::U8_NUMBER_OF_DATA_CONTENTS_PER_ONCE, u8NumberOfDataContentsPerOnce);
		if (!bIsParsingSuccess) {
			ETG_TRACE_ERR(("Parsing u8NumberOfDataContentsPerOnce FAILED!!"));
			return bIsParsingSuccess;
		}
		oChannelMasterData.ChannelMasterData.ChannelDefinitionInformation[i].u8NumOfDataContentsPerOnce = u8NumberOfDataContentsPerOnce;

		tU8 u8TotalNumOfDataContents = 0;
		bIsParsingSuccess= jsonUtils.gettU8UInt(jChannelDefinitionInformation[i], json_utils::U8_TOTAL_NUM_OF_DATA_CONTENTS, u8TotalNumOfDataContents);
		if (!bIsParsingSuccess) {
			ETG_TRACE_ERR(("Parsing u8TotalNumOfDataContents FAILED!!"));
			return bIsParsingSuccess;
		}
		oChannelMasterData.ChannelMasterData.ChannelDefinitionInformation[i].u8TotalNumOfChannelContents = u8TotalNumOfDataContents;

		// Get FolderID
		tU16 u16FolderID;
		bIsParsingSuccess = jsonUtils.gettU16UInt(jChannelDefinitionInformation[i], json_utils::U16_FOLDER_ID, u16FolderID);
		if (!bIsParsingSuccess) {
			ETG_TRACE_ERR(("Parsing ChannelDefinitionInformation-FolderID FAILED!!"));
			return bIsParsingSuccess;
		}
		oChannelMasterData.ChannelMasterData.ChannelDefinitionInformation[i].u16FolderID = u16FolderID;

		tU16 u16ChannelIconID;
		bIsParsingSuccess= jsonUtils.gettU16UInt(jChannelDefinitionInformation[i], json_utils::U16_CHANNEL_ICON_ID, u16ChannelIconID);
		if (!bIsParsingSuccess) {
			ETG_TRACE_ERR(("Parsing ChannelIconID FAILED!!"));
			return bIsParsingSuccess;
		}
		oChannelMasterData.ChannelMasterData.ChannelDefinitionInformation[i].u16ChannelIconID = u16ChannelIconID;

		tU8 u8FlagOfChannelInfo;
		bIsParsingSuccess = jsonUtils.gettU8UInt(jChannelDefinitionInformation[i], json_utils::U8_FLAG_OF_CHANNEL_INFO,u8FlagOfChannelInfo);
		if (!bIsParsingSuccess) {
			ETG_TRACE_ERR(("Parsing FlagOfChannelInfo FAILED!!"));
			return bIsParsingSuccess;
		}
		oChannelMasterData.ChannelMasterData.ChannelDefinitionInformation[i].u8FlagOfChannelInfo = u8FlagOfChannelInfo;
	}

    return bIsParsingSuccess;
}

/******************************************** FAVORITE CHANNEL LIST *************************************************************************/
tBool fc_usb_tcu_PRC_JSONParser::bParseFavoriteChannelList(Json::Value& root, T_tcu_Favorite_Channel_List& oFavoriteChannelDataList)
{
	ETG_TRACE_USR2(("<< bParseFavoriteChannelList"));
	tBool bIsParsingSuccess = false;

	//Get FavoriteChannelList JSON message
	Json::Value jFavChannelList;
	bIsParsingSuccess = jsonUtils.getJSONObject(root, json_utils::FAVORITE_CHANNEL_LIST, jFavChannelList);

	tU8 u8NumOfFavoriteChannelList = 0;
	if(bIsParsingSuccess) {
		bIsParsingSuccess = jsonUtils.gettU8UInt(jFavChannelList,json_utils::U8_NUM_OF_FAVORITE_CHANNEL_LIST, u8NumOfFavoriteChannelList);
	}

	Json::Value jFavChannelListRecord;
	if(bIsParsingSuccess) {
		bIsParsingSuccess = jsonUtils.getJSONArray(jFavChannelList, json_utils::FAVORITE_CHANNEL_LIST_RECORD, jFavChannelListRecord);
	}

	if(bIsParsingSuccess) {
		oFavoriteChannelDataList.FavoriteChannelInfoList.resize(u8NumOfFavoriteChannelList);
		for (tC16 i = 0; i < u8NumOfFavoriteChannelList; i++)
		{
			bIsParsingSuccess = jsonUtils.gettU8UInt(jFavChannelListRecord[i], json_utils::U8_FAVORITE_CHANNEL_LIST_ID, oFavoriteChannelDataList.FavoriteChannelInfoList[i].u8FavoriteChannelListID);
			if (bIsParsingSuccess == FALSE ) {
				break;
			}

			bIsParsingSuccess = jsonUtils.gettU16UInt(jFavChannelListRecord[i], json_utils::U16_CHANNEL_ID, oFavoriteChannelDataList.FavoriteChannelInfoList[i].u16ChannelID);
			if (bIsParsingSuccess == FALSE ) {
				break;
			}

			bIsParsingSuccess = jsonUtils.getString(jFavChannelListRecord[i], json_utils::STR_CHANNEL_NAME, oFavoriteChannelDataList.FavoriteChannelInfoList[i].strChannelName);
			if (bIsParsingSuccess == FALSE ) {
				break;
			}

			bIsParsingSuccess = jsonUtils.getString(jFavChannelListRecord[i], json_utils::STR_CHANNEL_NAME_FOR_TTS, oFavoriteChannelDataList.FavoriteChannelInfoList[i].strChannelNameForTTS);
			if (bIsParsingSuccess == FALSE ) {
				break;
			}

			tU8 u8ChannelGenModeID = 0;
			bIsParsingSuccess = jsonUtils.gettU8UInt(jFavChannelListRecord[i], json_utils::U8_CHANNEL_GEN_MODE_ID, u8ChannelGenModeID);
			if (bIsParsingSuccess == FALSE ) {
				break;
			}
			else
			{
				oFavoriteChannelDataList.FavoriteChannelInfoList[i].u8ChannelGenModeID = T_e8_tcu_ChannelGenModeID::tenType(u8ChannelGenModeID);
			}
		}
	}


	if (!bIsParsingSuccess)
	{
		ETG_TRACE_USR2(("Parsing JSON FAILED!!"));
	}

	return bIsParsingSuccess;
}

tBool fc_usb_tcu_PRC_JSONParser::bParseAuthenticationResultData(Json::Value root, T_tcu_AuthenticationResultData& oAuthenticationResultData)
{
	ETG_TRACE_USR2(("<< parseAuthenticationResultData"));
	tBool bIsParsingSuccess = true;
	
	Json::Value jAuthenticationResultData;
	
	bIsParsingSuccess = jsonUtils.getJSONObject(root, json_utils::AUTHENTICATIONRESULTDATA, jAuthenticationResultData);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}
	
	bIsParsingSuccess = jsonUtils.getString(jAuthenticationResultData, json_utils::STR_AUTH_DISPLAY_MESSAGE, oAuthenticationResultData.strDisplayMessage);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}
	
	bIsParsingSuccess = jsonUtils.getString(jAuthenticationResultData, json_utils::STR_AUTH_TTS_MESSAGE, oAuthenticationResultData.strTTSTextMessage);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}
	
	tU8 u8Result = 0;
	bIsParsingSuccess = jsonUtils.gettU8UInt(jAuthenticationResultData, json_utils::U8_AUTHENTICATION_RESULT, u8Result);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}
	else
	{
		oAuthenticationResultData.u8Result = T_e8_tcu_AuthResult::tenType(u8Result);
	}	
	ETG_TRACE_USR2((">> parseAuthenticationResultData"));
	return bIsParsingSuccess;	
}

tBool fc_usb_tcu_PRC_JSONParser::vParseChargingStationsData(
		tU32& u32ClientToken,
		Json::Value& root, T_tcu_response_charging_stations_list_result& oChargingStationsData)
{
	ETG_TRACE_USR2(("<< parseChargingStationsData"));
	tBool bIsParsingSuccess = false;

//	tU32 u32ClientToken = 0;
	bIsParsingSuccess = jsonUtils.gettU32UInt(root, json_utils::U32_REQ_ID, u32ClientToken);
	ETG_TRACE_USR2(("u32ClientToken: %u", u32ClientToken));

	//Get charging stations JSON message
	Json::Value jCSD;
	if(bIsParsingSuccess == TRUE){
		bIsParsingSuccess = jsonUtils.getJSONObject(root, json_utils::CHARGING_STATIONS, jCSD);
	}
	if (bIsParsingSuccess)
	{
		bIsParsingSuccess = parseChargingStationsDataHeader(jCSD, oChargingStationsData);
	}

	if (bIsParsingSuccess)
	{
		//Get POIIDList
		Json::Value jPOIIDInfoList;
		bIsParsingSuccess = jsonUtils.getJSONArray(jCSD, json_utils::POIID_LIST_DATA, jPOIIDInfoList);

		if(bIsParsingSuccess)
		{
			oChargingStationsData.ChargingStations.POIIDInfoList.resize(jPOIIDInfoList.size());
			for (tC16 i = 0; i < jPOIIDInfoList.size(); i++)
			{
				if (bIsParsingSuccess)
				{
					bIsParsingSuccess = parseChargingStationsDataInformation(jPOIIDInfoList[i], oChargingStationsData.ChargingStations.POIIDInfoList[i]);
				}
			}
		}
	}

	if (!bIsParsingSuccess)
	{
		ETG_TRACE_USR2(("Parsing JSON FAILED!!"));
	}

	return bIsParsingSuccess;
}

tBool fc_usb_tcu_PRC_JSONParser::parseChargingStationsDataHeader(Json::Value & jCSD, T_tcu_response_charging_stations_list_result & oChargingStationsData)
{
	ETG_TRACE_USR2(("<< parseChargingStationsDataHeader"));

	tBool bIsParsingSuccess = false;
    Json::Value jCSDHeader;
    tBool boolGetCSDHeaderJSONObj = jsonUtils.getJSONObject(jCSD, json_utils::LIST_OF_CHARGING_STATIONS_HEADER, jCSDHeader);

    if (boolGetCSDHeaderJSONObj)
    {
		//Get POI Data Set Identification ID Type.
		tU8 u8POIDataSetIdentificationIDType;
		bIsParsingSuccess = jsonUtils.gettU8UInt(jCSDHeader, json_utils::U8_POI_DATASET_IDENTIFICATION_ID_TYPE, u8POIDataSetIdentificationIDType);
		if (bIsParsingSuccess)
		{
			oChargingStationsData.ChargingStations.ChargingStationsResponseHeader.u8POIDataSetIdentificationIDType = u8POIDataSetIdentificationIDType;
		}

		//Get POI Data Set Identification ID
		tU32 u32POIDataSetIdentificationID;
		bIsParsingSuccess = jsonUtils.gettU32UInt(jCSDHeader, json_utils::U32_POI_DATASET_IDENTIFICATION_ID, u32POIDataSetIdentificationID);
		if (bIsParsingSuccess)
		{
			oChargingStationsData.ChargingStations.ChargingStationsResponseHeader.u32POIDataSetIdentificationID = u32POIDataSetIdentificationID;
		}

		//Get Number Of POI ID
		tU32 u32NumberOfPOIID;
		bIsParsingSuccess = jsonUtils.gettU32UInt(jCSDHeader, json_utils::U32_NUMBER_OF_POI_ID, u32NumberOfPOIID);
		if (bIsParsingSuccess)
		{
			oChargingStationsData.ChargingStations.ChargingStationsResponseHeader.u32NumberOfPOIID = u32NumberOfPOIID;
		}
	}

    return bIsParsingSuccess;
}

tBool fc_usb_tcu_PRC_JSONParser::parseChargingStationsDataInformation(Json::Value& jPOIIDData, T_tcu_charging_stations_response_datarecord& oPOIIDInfo)
{
	ETG_TRACE_USR2(("-> parsePOIIDDataInformation()"));
	tBool bIsParsingSuccess = FALSE;

	//Get POIID
	tU32 u32POIID;
	bIsParsingSuccess = jsonUtils.gettU32UInt(jPOIIDData, json_utils::U32_POIID, u32POIID);

	if(bIsParsingSuccess)
	{
		oPOIIDInfo.u32POIID = u32POIID;
	}

	//Get POIIDVersion
	tU32 u32POIIDVersion;
	bIsParsingSuccess = jsonUtils.gettU32UInt(jPOIIDData, json_utils::U32_POI_ID_VERSION, u32POIIDVersion);
	if(bIsParsingSuccess)
	{
		oPOIIDInfo.u32POIIDVersion = u32POIIDVersion;
	}

	// POIIDPositionCoordinate
	Json::Value jLocation;
	bIsParsingSuccess = jsonUtils.getJSONObject(jPOIIDData, json_utils::LOCATION, jLocation);
	if (bIsParsingSuccess)
	{
		bIsParsingSuccess = parseLocationCoordinate(jLocation, oPOIIDInfo.Location);
	}

	ETG_TRACE_USR2(("<- parsePOIIDDataInformation()"));
	return bIsParsingSuccess;
}

tBool fc_usb_tcu_PRC_JSONParser::parseLocationCoordinate(Json::Value & jLocation, T_tcu_Location& oLocation)
{
	ETG_TRACE_USR2((">> parseLocationCoordinate"));

	tBool bIsParsingSuccess = FALSE;

	//Get the channel content ID
	tU8 u8Direction = 0;
	bIsParsingSuccess = jsonUtils.gettU8UInt(jLocation, json_utils::U8_DIRECTION, u8Direction);

	//Get the Longitude Degree
	tU8 u8Longitude_degree = 0;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.gettU8UInt(jLocation, json_utils::U8_LONGITUDE_DEGREE, u8Longitude_degree);
	}

	//Get the Longitude minute
	tU8 u8Longitude_minute = 0;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.gettU8UInt(jLocation, json_utils::U8_LONGITUDE_MINUTE, u8Longitude_minute);
	}

	//Get the Longitude second
	tU16 u16Longitude_second = 0;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.gettU16UInt(jLocation, json_utils::U16_LONGITUDE_SECOND, u16Longitude_second);
	}
	//Get the Latitude degree
	tU8 u8Latitude_degree = 0;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.gettU8UInt(jLocation, json_utils::U8_LATITUDE_DEGREE, u8Latitude_degree);
	}

	//Get the Latitude minute
	tU8 u8Latitude_minute = 0;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.gettU8UInt(jLocation, json_utils::U8_LATITUDE_MINUTE, u8Latitude_minute);
	}

	//Get the Latitude second
	tU16 u16Latitude_second = 0;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.gettU16UInt(jLocation, json_utils::U16_LATITUDE_SECOND, u16Latitude_second);
	}

	if(bIsParsingSuccess == TRUE)
	{
		T_tcu_Location tempoLocation(u8Direction,
									 u8Longitude_degree,
									 u8Longitude_minute,
									 u16Longitude_second,
									 u8Latitude_degree,
									 u8Latitude_minute,
									 u16Latitude_second);
		oLocation = tempoLocation;
	}

	ETG_TRACE_USR2(("<< parseLocationCoordinate"));
	return bIsParsingSuccess;
}


tBool fc_usb_tcu_PRC_JSONParser::vParseChargingSpotData(Json::Value & ChargingSpotData, T_tcu_charging_spot& oChargingSpotData)
{
	ETG_TRACE_USR2(("<< vParseChargingSpotData"));
	tBool bIsParsingSuccess = FALSE;
	

	//Get charging spot data JSON message
	Json::Value jCSD;
	bIsParsingSuccess = jsonUtils.getJSONObject(ChargingSpotData, json_utils::CHARGING_SPOT_DATA, jCSD);
	
	tU32 u32POIID = 0;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.gettU32UInt(jCSD, json_utils::U32_POIID, u32POIID);
	}	
		
	bpstl::string strPOIName;
	if (bIsParsingSuccess == TRUE)
	{
		oChargingSpotData.u32POIID = u32POIID;
		bIsParsingSuccess = jsonUtils.getString(jCSD, json_utils::STR_POI_NAME, strPOIName);
	}
	
	bpstl::string strAreaCode1;
	if (bIsParsingSuccess == TRUE)
	{
		oChargingSpotData.strPOIName = strPOIName;
		bIsParsingSuccess = jsonUtils.getString(jCSD, json_utils::STR_AREA_CODE1, strAreaCode1);
	}
	
	bpstl::string strAreaCode2;
	if (bIsParsingSuccess == TRUE)
	{
		oChargingSpotData.strAreaCode1 = strAreaCode1;
		bIsParsingSuccess = jsonUtils.getString(jCSD, json_utils::STR_AREA_CODE2, strAreaCode2);
	}

	bpstl::string strAreaCode3;
	if (bIsParsingSuccess == TRUE)
	{
		oChargingSpotData.strAreaCode2 = strAreaCode2;
		bIsParsingSuccess = jsonUtils.getString(jCSD, json_utils::STR_AREA_CODE3, strAreaCode3);
	}

	bpstl::string strAreaCode4;
	if (bIsParsingSuccess == TRUE)
	{
		oChargingSpotData.strAreaCode3 = strAreaCode3;
		bIsParsingSuccess = jsonUtils.getString(jCSD, json_utils::STR_AREA_CODE4, strAreaCode4);
	}

	bpstl::string strAreaCode5;
	if (bIsParsingSuccess == TRUE)
	{
		oChargingSpotData.strAreaCode4 = strAreaCode4;
		bIsParsingSuccess = jsonUtils.getString(jCSD, json_utils::STR_AREA_CODE5, strAreaCode5);
	}

	bpstl::string strAreaCode6;
	if (bIsParsingSuccess == TRUE)
	{
		oChargingSpotData.strAreaCode5 = strAreaCode5;
		bIsParsingSuccess = jsonUtils.getString(jCSD, json_utils::STR_AREA_CODE6, strAreaCode6);
	}

	bpstl::string strAreaCode7;
	if (bIsParsingSuccess == TRUE)
	{
		oChargingSpotData.strAreaCode6 = strAreaCode6;
		bIsParsingSuccess = jsonUtils.getString(jCSD, json_utils::STR_AREA_CODE7, strAreaCode7);
	}
	
	bpstl::string strAreaCode8;
	if (bIsParsingSuccess == TRUE)
	{
		oChargingSpotData.strAreaCode7 = strAreaCode7;
		bIsParsingSuccess = jsonUtils.getString(jCSD, json_utils::STR_AREA_CODE8, strAreaCode8);
	}

	bpstl::string strStreetAndHouseNo;
	if (bIsParsingSuccess == TRUE)
	{
		oChargingSpotData.strAreaCode8 = strAreaCode8;
		bIsParsingSuccess = jsonUtils.getString(jCSD, json_utils::STR_STREET_AND_HOUSE_NO, strStreetAndHouseNo);
	}
	
	tU16 u16Categorycode = 0;
	if(bIsParsingSuccess == TRUE)
	{
		oChargingSpotData.strStreetAndHouseNo = strStreetAndHouseNo;
		bIsParsingSuccess = jsonUtils.gettU16UInt(jCSD, json_utils::U16_CATEGORY_CODE, u16Categorycode);
	}
	
	tU16 u16Subcategorycode = 0;
	if(bIsParsingSuccess == TRUE)
	{
		oChargingSpotData.u16Categorycode = u16Categorycode;
		bIsParsingSuccess = jsonUtils.gettU16UInt(jCSD, json_utils::U16_SUB_CATEGORY_CODE, u16Subcategorycode);
	}
	
	bpstl::string strTelephonenumber;
	if (bIsParsingSuccess == TRUE)
	{
		oChargingSpotData.u16Subcategorycode = u16Subcategorycode;
		bIsParsingSuccess = jsonUtils.getString(jCSD, json_utils::STR_TELEPHONE_NUMBER, strTelephonenumber);
	}

	tU8 u8Expresswaygeneraltype = 0;
	if(bIsParsingSuccess == TRUE)
	{
		oChargingSpotData.strTelephonenumber = strTelephonenumber;
		bIsParsingSuccess = jsonUtils.gettU8UInt(jCSD, json_utils::U8_EXPRESS_WAY_GENERAL_TYPE, u8Expresswaygeneraltype);
	}

	tU8 u8Informationreliability = 0;
	if(bIsParsingSuccess == TRUE)
	{
		oChargingSpotData.u8Expresswaygeneraltype = u8Expresswaygeneraltype;
		bIsParsingSuccess = jsonUtils.gettU8UInt(jCSD, json_utils::U8_INFORMATION_RELIABILITY, u8Informationreliability);
	}

	tU8 u8Userrestriction = 0;
	if(bIsParsingSuccess == TRUE)
	{
		oChargingSpotData.u8Informationreliability = u8Informationreliability;
		bIsParsingSuccess = jsonUtils.gettU8UInt(jCSD, json_utils::U8_USER_RESTRICTION, u8Userrestriction);
	}		
	
	tU32 u32UserrestrictionID = 0;
	if(bIsParsingSuccess == TRUE)
	{
		oChargingSpotData.u8Userrestriction = u8Userrestriction;
		bIsParsingSuccess = jsonUtils.gettU32UInt(jCSD, json_utils::U32_USER_RESTRICTION_ID, u32UserrestrictionID);
	}
	
	tU8 u8Thenumberofentranceinformation = 0;
	if(bIsParsingSuccess == TRUE)
	{
		oChargingSpotData.u32UserrestrictionID = u32UserrestrictionID;
		bIsParsingSuccess = jsonUtils.gettU8UInt(jCSD, json_utils::U8_THE_NUMBER_OF_ENTRANCE_INFORMATION, u8Thenumberofentranceinformation);
	}

	tU8 u8Entranceinformation = 0;
	if(bIsParsingSuccess == TRUE)
	{
		oChargingSpotData.u8Thenumberofentranceinformation = u8Thenumberofentranceinformation;
		bIsParsingSuccess = jsonUtils.gettU8UInt(jCSD, json_utils::U8_ENTRANCE_INFORMATION, u8Entranceinformation);
	}

	tU8 u8Thenumberofpartnersfacilityinformation = 0;
	if(bIsParsingSuccess == TRUE)
	{
		oChargingSpotData.u8Entranceinformation = u8Entranceinformation;
		bIsParsingSuccess = jsonUtils.gettU8UInt(jCSD, json_utils::U8_THE_NUMBER_OF_PARTNERS_FACILITY_INFORMATION, u8Thenumberofpartnersfacilityinformation);
	}

	tU8 u8Partnersfacilityinformation = 0;
	if(bIsParsingSuccess == TRUE)
	{
		oChargingSpotData.u8Thenumberofpartnersfacilityinformation = u8Thenumberofpartnersfacilityinformation;
		bIsParsingSuccess = jsonUtils.gettU8UInt(jCSD, json_utils::U8_PARTNERS_FACILITY_INFORMATION, u8Partnersfacilityinformation);
	}

	tU8 u8Thenumberofinstallationfacilityinformation = 0;
	if(bIsParsingSuccess == TRUE)
	{
		oChargingSpotData.u8Partnersfacilityinformation = u8Partnersfacilityinformation;
		bIsParsingSuccess = jsonUtils.gettU8UInt(jCSD, json_utils::U8_THE_NUMBER_OF_INSTALLATION_FACILITY_INFORMATION, u8Thenumberofinstallationfacilityinformation);
	}

	tU8 u8Installationfacilityinformation = 0;
	if(bIsParsingSuccess == TRUE)
	{
		oChargingSpotData.u8Thenumberofinstallationfacilityinformation = u8Thenumberofinstallationfacilityinformation;
		bIsParsingSuccess = jsonUtils.gettU8UInt(jCSD, json_utils::U8_INSTALLATION_FACILITY_INFORMATION, u8Installationfacilityinformation);
	}

	tU8 u8Thetotalnumberofchargingtype = 0;
	if(bIsParsingSuccess == TRUE)
	{
		oChargingSpotData.u8Installationfacilityinformation = u8Installationfacilityinformation;
		bIsParsingSuccess = jsonUtils.gettU8UInt(jCSD, json_utils::U8_THE_TOTAL_NUMBER_OF_CHARGING_TYPE, u8Thetotalnumberofchargingtype);
	}

	tU8 u8Chargingtype = 0;
	if(bIsParsingSuccess == TRUE)
	{
		oChargingSpotData.u8Thetotalnumberofchargingtype = u8Thetotalnumberofchargingtype;
		bIsParsingSuccess = jsonUtils.gettU8UInt(jCSD, json_utils::U8_CHARGING_TYPE, u8Chargingtype);
	}
	
	tU16 u16Parkingnumber = 0;
	if(bIsParsingSuccess == TRUE)
	{
		oChargingSpotData.u8Chargingtype = u8Chargingtype;
		bIsParsingSuccess = jsonUtils.gettU16UInt(jCSD, json_utils::U16_PARKING_NUMBER, u16Parkingnumber);
	}

	tU8 u8Fixedvalue1 = 0;
	if(bIsParsingSuccess == TRUE)
	{
		oChargingSpotData.u16Parkingnumber = u16Parkingnumber;
		bIsParsingSuccess = jsonUtils.gettU8UInt(jCSD, json_utils::U8_FIXED_VALUE_1, u8Fixedvalue1);
	}

	tU8 u8Fixedvalue2 = 0;
	if(bIsParsingSuccess == TRUE)
	{
		oChargingSpotData.u8Fixedvalue1 = u8Fixedvalue1;
		bIsParsingSuccess = jsonUtils.gettU8UInt(jCSD, json_utils::U8_FIXED_VALUE_2, u8Fixedvalue2);
	}	
	
	tU8 u8Detailsinformation = 0;
	if(bIsParsingSuccess == TRUE)
	{
		oChargingSpotData.u8Fixedvalue2 = u8Fixedvalue2;
		bIsParsingSuccess = jsonUtils.gettU8UInt(jCSD, json_utils::U8_DETAILS_INFORMATION, u8Detailsinformation);
	}

	tU8 u8_24hoursadayinformation = 0;
	if(bIsParsingSuccess == TRUE)
	{
		oChargingSpotData.u8Detailsinformation = u8Detailsinformation;
		bIsParsingSuccess = jsonUtils.gettU8UInt(jCSD, json_utils::U8_24_HOURS_A_DAY_INFORMATION, u8_24hoursadayinformation);
	}

	tU8 u8Officehoursunknowninformation = 0;
	if(bIsParsingSuccess == TRUE)
	{
		oChargingSpotData.u8_24hoursadayinformation = u8_24hoursadayinformation;
		bIsParsingSuccess = jsonUtils.gettU8UInt(jCSD, json_utils::U8_OFFICE_HOURS_UNKNOWN_INFORMATION, u8Officehoursunknowninformation);
	}

	tU8 u8Chargingfeeinformation = 0;
	if(bIsParsingSuccess == TRUE)
	{
		oChargingSpotData.u8Officehoursunknowninformation = u8Officehoursunknowninformation;
		bIsParsingSuccess = jsonUtils.gettU8UInt(jCSD, json_utils::U8_CHARGING_FEE_INFORMATION, u8Chargingfeeinformation);
	}

	tU8 u8Businessdayoftheweekinformation = 0;
	if(bIsParsingSuccess == TRUE)
	{
		oChargingSpotData.u8Chargingfeeinformation = u8Chargingfeeinformation;
		bIsParsingSuccess = jsonUtils.gettU8UInt(jCSD, json_utils::U8_BUSINESS_DAY_OF_THE_WEEK_INFORMATION, u8Businessdayoftheweekinformation);
	}

	tU16 u16OpeninghourInformation = 0;
	if(bIsParsingSuccess == TRUE)
	{
		oChargingSpotData.u8Businessdayoftheweekinformation = u8Businessdayoftheweekinformation;
		bIsParsingSuccess = jsonUtils.gettU16UInt(jCSD, json_utils::U16_OPENING_HOUR_INFORMATION, u16OpeninghourInformation);
	}

	tU16 u16ClosedhourInformation = 0;
	if(bIsParsingSuccess == TRUE)
	{
		oChargingSpotData.u16OpeninghourInformation = u16OpeninghourInformation;
		bIsParsingSuccess = jsonUtils.gettU16UInt(jCSD, json_utils::U16_CLOSED_HOUR_INFORMATION, u16ClosedhourInformation);
	}	
	
	tU8 u8Nearthefacilityinformation = 0;
	if(bIsParsingSuccess == TRUE)
	{
		oChargingSpotData.u16ClosedhourInformation = u16ClosedhourInformation;
		bIsParsingSuccess = jsonUtils.gettU8UInt(jCSD, json_utils::U8_NEAR_THE_FACILITY_INFORMATION, u8Nearthefacilityinformation);
	}
	
	tU16 u16Paymenttypeinformation = 0;
	if(bIsParsingSuccess == TRUE)
	{
		oChargingSpotData.u8Nearthefacilityinformation = u8Nearthefacilityinformation;
		bIsParsingSuccess = jsonUtils.gettU16UInt(jCSD, json_utils::U16_PAYMENT_TYPE_INFORMATION, u16Paymenttypeinformation);
	}
	
	if(bIsParsingSuccess == TRUE)
	{
		oChargingSpotData.u16Paymenttypeinformation = u16Paymenttypeinformation;
	}
	
    // POIIDPositionCoordinate
	Json::Value jLocation;
	bIsParsingSuccess = jsonUtils.getJSONObject(jCSD, json_utils::LOCATION, jLocation);
	if (bIsParsingSuccess)
	{
		bIsParsingSuccess = parseLocationCoordinate(jLocation, oChargingSpotData.Location);
	}

	if (!bIsParsingSuccess)
	{
		ETG_TRACE_USR2(("Parsing JSON FAILED!!"));
	}

	return bIsParsingSuccess;	
}
//@rav1hc: This function only for JPN
tBool fc_usb_tcu_PRC_JSONParser::vParseChargingSpotDataforJPN(
		tU32& u32ClientToken,
		Json::Value& ChargingSpotDataJPN,
		T_tcu_charging_spot_data_JPN& oChargingSpotDataJPN) {

	ETG_TRACE_USR2(("<< vParseChargingSpotDataforJPN"));
	tBool bIsParsingSuccess = FALSE;

//	tU32 u32ClientToken = 0;
	bIsParsingSuccess = jsonUtils.gettU32UInt(ChargingSpotDataJPN, json_utils::U32_REQ_ID, u32ClientToken);
	ETG_TRACE_USR2(("u32ClientToken: %u", u32ClientToken));

	//Get charging spot data JSON message
	Json::Value jCSD;
	if(bIsParsingSuccess == TRUE)
		bIsParsingSuccess = jsonUtils.getJSONObject(ChargingSpotDataJPN, json_utils::CHARGING_SPOT_DATA, jCSD);

	tU32 u32POIID = 0;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.gettU32UInt(jCSD, json_utils::U32_POIID, u32POIID);
	}

	bpstl::string strPOIName;
	if (bIsParsingSuccess == TRUE)
	{
		oChargingSpotDataJPN.u32POIID = u32POIID;
		bIsParsingSuccess = jsonUtils.getString(jCSD, json_utils::STR_POI_NAME, strPOIName);
	}

	bpstl::string strPOINameForTTS;
	if (bIsParsingSuccess == TRUE)
	{
		oChargingSpotDataJPN.strPOIName = strPOIName;
		bIsParsingSuccess = jsonUtils.getString(jCSD, json_utils::STR_POI_NAME_FOR_TTS, strPOINameForTTS);
	}

	bpstl::string strAreaName1;
	if (bIsParsingSuccess == TRUE)
	{
		oChargingSpotDataJPN.strPOINameTTS = strPOINameForTTS;
		bIsParsingSuccess = jsonUtils.getString(jCSD, json_utils::STR_AREA_NAME1, strAreaName1);
	}

	bpstl::string strAreaName2;
	if (bIsParsingSuccess == TRUE)
	{
		oChargingSpotDataJPN.strAreaName1 = strAreaName1;
		bIsParsingSuccess = jsonUtils.getString(jCSD, json_utils::STR_AREA_NAME2, strAreaName2);
	}


	bpstl::string strOoazaAndAddress;
	if (bIsParsingSuccess == TRUE)
	{
		oChargingSpotDataJPN.strAreaName2 = strAreaName2;
		bIsParsingSuccess = jsonUtils.getString(jCSD, json_utils::STR_OOAZA_AND_ADD, strOoazaAndAddress);
	}

	tU16 u16Categorycode = 0;
	if(bIsParsingSuccess == TRUE)
	{
		oChargingSpotDataJPN.strOoazaAddress = strOoazaAndAddress;
		bIsParsingSuccess = jsonUtils.gettU16UInt(jCSD, json_utils::U16_CATEGORY_CODE, u16Categorycode);
	}

	tU16 u16Subcategorycode = 0;
	if(bIsParsingSuccess == TRUE)
	{
		oChargingSpotDataJPN.u16Categorycode = u16Categorycode;
		bIsParsingSuccess = jsonUtils.gettU16UInt(jCSD, json_utils::U16_SUB_CATEGORY_CODE, u16Subcategorycode);
	}

	bpstl::string strTelephonenumber;
	if (bIsParsingSuccess == TRUE)
	{
		oChargingSpotDataJPN.u16Subcategorycode = u16Subcategorycode;
		bIsParsingSuccess = jsonUtils.getString(jCSD, json_utils::STR_TELEPHONE_NUMBER, strTelephonenumber);
	}

	tU8 u8Expresswaygeneraltype = 0;
	if(bIsParsingSuccess == TRUE)
	{
		oChargingSpotDataJPN.strTelephonenumber = strTelephonenumber;
		bIsParsingSuccess = jsonUtils.gettU8UInt(jCSD, json_utils::U8_EXPRESS_WAY_GENERAL_TYPE, u8Expresswaygeneraltype);
	}

	tU8 u8Informationreliability = 0;
	if(bIsParsingSuccess == TRUE)
	{
		oChargingSpotDataJPN.u8Expresswaygeneraltype = u8Expresswaygeneraltype;
		bIsParsingSuccess = jsonUtils.gettU8UInt(jCSD, json_utils::U8_INFORMATION_RELIABILITY, u8Informationreliability);
	}

	tU8 u8UserLimit = 0;
	if(bIsParsingSuccess == TRUE)
	{
		oChargingSpotDataJPN.u8Informationreliability = u8Informationreliability;
		bIsParsingSuccess = jsonUtils.gettU8UInt(jCSD, json_utils::U8_USER_LIMIT, u8UserLimit);
	}

	tU32 u32UserLimitID = 0;
	if(bIsParsingSuccess == TRUE)
	{
		oChargingSpotDataJPN.u8UserLimit = u8UserLimit;
		bIsParsingSuccess = jsonUtils.gettU32UInt(jCSD, json_utils::U32_USER_LIMIT_ID, u32UserLimitID);
	}


	tU8 u8_24hoursadayinformation = 0;
	if(bIsParsingSuccess == TRUE)
	{
//		oChargingSpotDataJPN.u8Thetotalnumberofchargingtype = u8Thetotalnumberofchargingtype;
		oChargingSpotDataJPN.u32UserLimitID = u32UserLimitID;
		bIsParsingSuccess = jsonUtils.gettU8UInt(jCSD, json_utils::U8_24_HOURS_A_DAY_INFORMATION, u8_24hoursadayinformation);
	}
//
//	tU8 u8Fixedvalue1 = 0;
//	if(bIsParsingSuccess == TRUE)
//	{
//		oChargingSpotDataJPN.u16Parkingnumber = u16Parkingnumber;
//		bIsParsingSuccess = jsonUtils.gettU8UInt(jCSD, json_utils::U8_FIXED_VALUE_1, u8Fixedvalue1);
//	}
//
//	tU8 u8Fixedvalue2 = 0;
//	if(bIsParsingSuccess == TRUE)
//	{
//		oChargingSpotDataJPN.u8Fixedvalue1 = u8Fixedvalue1;
//		bIsParsingSuccess = jsonUtils.gettU8UInt(jCSD, json_utils::U8_FIXED_VALUE_2, u8Fixedvalue2);
//	}
//
//	//cast string
//	bpstl::string strDetailsinformation;
//	if(bIsParsingSuccess == TRUE)
//	{
//		oChargingSpotDataJPN.u8Fixedvalue2 = u8Fixedvalue2;
//		bIsParsingSuccess = jsonUtils.getString(jCSD, json_utils::STR_DETAILS_INFORMATION, strDetailsinformation);
//	}

//	tU8 u8_24hoursadayinformation = 0;
//	if(bIsParsingSuccess == TRUE)
//	{
//		oChargingSpotDataJPN.strDetailsinformation = strDetailsinformation;
//		bIsParsingSuccess = jsonUtils.gettU8UInt(jCSD, json_utils::U8_24_HOURS_A_DAY_INFORMATION, u8_24hoursadayinformation);
//	}

	tU8 u8Officehoursunknowninformation = 0;
	if(bIsParsingSuccess == TRUE)
	{
		oChargingSpotDataJPN.u8_24hoursadayinformation = u8_24hoursadayinformation;
		bIsParsingSuccess = jsonUtils.gettU8UInt(jCSD, json_utils::U8_OFFICE_HOURS_UNKNOWN_INFORMATION, u8Officehoursunknowninformation);
	}

	tU8 u8Chargingfeeinformation = 0;
	if(bIsParsingSuccess == TRUE)
	{
		oChargingSpotDataJPN.u8Officehoursunknowninformation = u8Officehoursunknowninformation;
		bIsParsingSuccess = jsonUtils.gettU8UInt(jCSD, json_utils::U8_CHARGING_FEE_INFORMATION, u8Chargingfeeinformation);
	}

	tU8 u8Businessdayoftheweekinformation = 0;
	if(bIsParsingSuccess == TRUE)
	{
		oChargingSpotDataJPN.u8Chargingfeeinformation = u8Chargingfeeinformation;
		bIsParsingSuccess = jsonUtils.gettU8UInt(jCSD, json_utils::U8_BUSINESS_DAY_OF_THE_WEEK_INFORMATION, u8Businessdayoftheweekinformation);
	}

	tU16 u16OpeninghourInformation = 0;
	if(bIsParsingSuccess == TRUE)
	{
		oChargingSpotDataJPN.u8Businessdayoftheweekinformation = u8Businessdayoftheweekinformation;
		bIsParsingSuccess = jsonUtils.gettU16UInt(jCSD, json_utils::U16_OPENING_HOUR_INFORMATION, u16OpeninghourInformation);
	}

	tU16 u16ClosedhourInformation = 0;
	if(bIsParsingSuccess == TRUE)
	{
		oChargingSpotDataJPN.u16OpeninghourInformation = u16OpeninghourInformation;
		bIsParsingSuccess = jsonUtils.gettU16UInt(jCSD, json_utils::U16_CLOSED_HOUR_INFORMATION, u16ClosedhourInformation);
	}

	tU8 u8Nearthefacilityinformation = 0;
	if(bIsParsingSuccess == TRUE)
	{
		oChargingSpotDataJPN.u16ClosedhourInformation = u16ClosedhourInformation;
		bIsParsingSuccess = jsonUtils.gettU8UInt(jCSD, json_utils::U8_NEAR_THE_FACILITY_INFORMATION, u8Nearthefacilityinformation);
	}

	// POIIDPositionCoordinate
//	Json::Value jLocation;
//	bIsParsingSuccess = jsonUtils.getJSONObject(jCSD, json_utils::LOCATION, jLocation);
	if (bIsParsingSuccess== TRUE){
		bIsParsingSuccess = parseLocationForChargingSpotData(jCSD, oChargingSpotDataJPN.Location);

	}

	if(bIsParsingSuccess== TRUE){
		bIsParsingSuccess = parseEntranceinformationList(jCSD, oChargingSpotDataJPN.EntranceinformationList);
	}

	if(bIsParsingSuccess== TRUE){
		bIsParsingSuccess = parsePartnersfacilityinformationList(jCSD, oChargingSpotDataJPN.PartnersfacilityinformationList);
	}

	if(bIsParsingSuccess== TRUE){
		bIsParsingSuccess = parseInstallationfacilityinformationList(jCSD, oChargingSpotDataJPN.InstallationfacilityinformationList);
	}

	if(bIsParsingSuccess== TRUE){
		bIsParsingSuccess = parseChargingInfomationList(jCSD, oChargingSpotDataJPN.ChargingInfomationList);
	}

	if (!bIsParsingSuccess== TRUE){
		ETG_TRACE_USR2(("Parsing JSON FAILED!!"));
	}

	return bIsParsingSuccess;
}

tBool fc_usb_tcu_PRC_JSONParser::vParseVacancySpotDataforJPN(
		tU32& u32ClientToken,
		Json::Value& VacancySpotDataJPN,
		T_tcu_vacancy_spot_data_JPN& oVacancySpotDataJPN) {
	ETG_TRACE_USR2((">> vParseVacancySpotDataforJPN"));
	tBool bIsParsingSuccess = FALSE;
//	tU32 u32ClientToken = 0;
	bIsParsingSuccess = jsonUtils.gettU32UInt(VacancySpotDataJPN, json_utils::U32_REQ_ID, u32ClientToken);
	ETG_TRACE_USR2(("u32ClientToken: %u", u32ClientToken));
	//Get vacancy spot data JSON message
	Json::Value jVSD;
	if(bIsParsingSuccess == TRUE )
		bIsParsingSuccess = jsonUtils.getJSONObject(VacancySpotDataJPN, json_utils::VACANCY_SPOT_DATA, jVSD);

	tU32 u32POIID = 0;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.gettU32UInt(jVSD, json_utils::U32_POIID, u32POIID);
	}
//	ETG_TRACE_USR2((">> u32POIID : %u", u32POIID));

	bpstl::string strPOIName;
	if (bIsParsingSuccess == TRUE)
	{
		oVacancySpotDataJPN.u32POIID = u32POIID;
		bIsParsingSuccess = jsonUtils.getString(jVSD, json_utils::STR_POI_NAME, strPOIName);
	}

	bpstl::string strPOINameForTTS;
	if (bIsParsingSuccess == TRUE)
	{
		oVacancySpotDataJPN.strPOIName = strPOIName;
		bIsParsingSuccess = jsonUtils.getString(jVSD, json_utils::STR_POI_NAME_FOR_TTS, strPOINameForTTS);
	}

	bpstl::string strAreaName1;
	if (bIsParsingSuccess == TRUE)
	{
		oVacancySpotDataJPN.strPOINameTTS = strPOINameForTTS;
		bIsParsingSuccess = jsonUtils.getString(jVSD, json_utils::STR_AREA_NAME1, strAreaName1);
	}

	bpstl::string strAreaName2;
	if (bIsParsingSuccess == TRUE)
	{
		oVacancySpotDataJPN.strAreaName1 = strAreaName1;
		bIsParsingSuccess = jsonUtils.getString(jVSD, json_utils::STR_AREA_NAME2, strAreaName2);
	}



	bpstl::string strOoazaAndAddress;
	if (bIsParsingSuccess == TRUE)
	{
		oVacancySpotDataJPN.strAreaName2 = strAreaName2;
		bIsParsingSuccess = jsonUtils.getString(jVSD, json_utils::STR_OOAZA_AND_ADD, strOoazaAndAddress);
	}

	tU16 u16Categorycode = 0;
	if(bIsParsingSuccess == TRUE)
	{
		oVacancySpotDataJPN.strOoazaAddress = strOoazaAndAddress;
		bIsParsingSuccess = jsonUtils.gettU16UInt(jVSD, json_utils::U16_CATEGORY_CODE, u16Categorycode);
	}

	tU16 u16Subcategorycode = 0;
	if(bIsParsingSuccess == TRUE)
	{
		oVacancySpotDataJPN.u16Categorycode = u16Categorycode;
		bIsParsingSuccess = jsonUtils.gettU16UInt(jVSD, json_utils::U16_SUB_CATEGORY_CODE, u16Subcategorycode);
	}

	bpstl::string strTelephonenumber;
	if (bIsParsingSuccess == TRUE)
	{
		oVacancySpotDataJPN.u16Subcategorycode = u16Subcategorycode;
		bIsParsingSuccess = jsonUtils.getString(jVSD, json_utils::STR_TELEPHONE_NUMBER, strTelephonenumber);
	}

	tU8 u8Expresswaygeneraltype = 0;
	if(bIsParsingSuccess == TRUE)
	{
		oVacancySpotDataJPN.strTelephonenumber = strTelephonenumber;
		bIsParsingSuccess = jsonUtils.gettU8UInt(jVSD, json_utils::U8_EXPRESS_WAY_GENERAL_TYPE, u8Expresswaygeneraltype);
	}

	tU8 u8Informationreliability = 0;
	if(bIsParsingSuccess == TRUE)
	{
		oVacancySpotDataJPN.u8Expresswaygeneraltype = u8Expresswaygeneraltype;
		bIsParsingSuccess = jsonUtils.gettU8UInt(jVSD, json_utils::U8_INFORMATION_RELIABILITY, u8Informationreliability);
	}

	tU8 u8Userrestriction = 0;
	if(bIsParsingSuccess == TRUE)
	{
		oVacancySpotDataJPN.u8Informationreliability = u8Informationreliability;
		bIsParsingSuccess = jsonUtils.gettU8UInt(jVSD, json_utils::U8_USER_RESTRICTION, u8Userrestriction);
	}

	tU32 u32UserrestrictionID = 0;
	if(bIsParsingSuccess == TRUE)
	{
		oVacancySpotDataJPN.u8Userrestriction = u8Userrestriction;
		bIsParsingSuccess = jsonUtils.gettU32UInt(jVSD, json_utils::U32_USER_RESTRICTION_ID, u32UserrestrictionID);
	}


	tU8 u8_24hoursadayinformation = 0;
	if(bIsParsingSuccess == TRUE)
	{
//		oVacancySpotDataJPN.u8Thetotalnumberofchargingtype = u8Thetotalnumberofchargingtype;
		oVacancySpotDataJPN.u32UserrestrictionID = u32UserrestrictionID;
		bIsParsingSuccess = jsonUtils.gettU8UInt(jVSD, json_utils::U8_24_HOURS_A_DAY_INFORMATION, u8_24hoursadayinformation);
	}

	tU8 u8Officehoursunknowninformation = 0;
	if(bIsParsingSuccess == TRUE)
	{
		oVacancySpotDataJPN.u8_24hoursadayinformation = u8_24hoursadayinformation;
		bIsParsingSuccess = jsonUtils.gettU8UInt(jVSD, json_utils::U8_OFFICE_HOURS_UNKNOWN_INFORMATION, u8Officehoursunknowninformation);
	}

	tU8 u8Chargingfeeinformation = 0;
	if(bIsParsingSuccess == TRUE)
	{
		oVacancySpotDataJPN.u8Officehoursunknowninformation = u8Officehoursunknowninformation;
		bIsParsingSuccess = jsonUtils.gettU8UInt(jVSD, json_utils::U8_CHARGING_FEE_INFORMATION, u8Chargingfeeinformation);
	}

	tU8 u8Businessdayoftheweekinformation = 0;
	if(bIsParsingSuccess == TRUE)
	{
		oVacancySpotDataJPN.u8Chargingfeeinformation = u8Chargingfeeinformation;
		bIsParsingSuccess = jsonUtils.gettU8UInt(jVSD, json_utils::U8_BUSINESS_DAY_OF_THE_WEEK_INFORMATION, u8Businessdayoftheweekinformation);
	}

	tU16 u16OpeninghourInformation = 0;
	if(bIsParsingSuccess == TRUE)
	{
		oVacancySpotDataJPN.u8Businessdayoftheweekinformation = u8Businessdayoftheweekinformation;
		bIsParsingSuccess = jsonUtils.gettU16UInt(jVSD, json_utils::U16_OPENING_HOUR_INFORMATION, u16OpeninghourInformation);
	}

	tU16 u16ClosedhourInformation = 0;
	if(bIsParsingSuccess == TRUE)
	{
		oVacancySpotDataJPN.u16OpeninghourInformation = u16OpeninghourInformation;
		bIsParsingSuccess = jsonUtils.gettU16UInt(jVSD, json_utils::U16_CLOSED_HOUR_INFORMATION, u16ClosedhourInformation);
	}

	tU8 u8Nearthefacilityinformation = 0;
	if(bIsParsingSuccess == TRUE)
	{
		oVacancySpotDataJPN.u16ClosedhourInformation = u16ClosedhourInformation;
		bIsParsingSuccess = jsonUtils.gettU8UInt(jVSD, json_utils::U8_NEAR_THE_FACILITY_INFORMATION, u8Nearthefacilityinformation);
	}

	// POIIDPositionCoordinate
//	Json::Value jLocation;
//	bIsParsingSuccess = jsonUtils.getJSONObject(jVSD, json_utils::LOCATION, jLocation);
	if (bIsParsingSuccess== TRUE){
		bIsParsingSuccess = parseLocationForChargingSpotData(jVSD, oVacancySpotDataJPN.Location);

	}

	if(bIsParsingSuccess== TRUE){
		bIsParsingSuccess = parseEntranceinformationList(jVSD, oVacancySpotDataJPN.EntranceinformationList);
	}

	if(bIsParsingSuccess== TRUE){
		bIsParsingSuccess = parsePartnersfacilityinformationList(jVSD, oVacancySpotDataJPN.PartnersfacilityinformationList);
	}

	if(bIsParsingSuccess== TRUE){
		bIsParsingSuccess = parseInstallationfacilityinformationList(jVSD, oVacancySpotDataJPN.InstallationfacilityinformationList);
	}

	if(bIsParsingSuccess== TRUE){
		bIsParsingSuccess = parseVacancyChargingInfomationList(jVSD, oVacancySpotDataJPN.ChargingInfomationList);
	}
//
//	if(bIsParsingSuccess== TRUE){
//		bIsParsingSuccess = parseInformationProvisionTime(jVSD, oVacancySpotDataJPN.InfoProvisionTime);
//	}

	if (!bIsParsingSuccess== TRUE){
		ETG_TRACE_USR2(("Parsing JSON FAILED!!"));
	}

	ETG_TRACE_USR2(("<- vParseVacancySpotDataforJPN()"));
	return bIsParsingSuccess;
}

tBool fc_usb_tcu_PRC_JSONParser::parseInformationProvisionTime(
		Json::Value& root,
		T_tcu_infomation_provision_time& oInformationProvisionTime) {
	ETG_TRACE_USR2(("<< parseInformationProvisionTime"));
	tBool bIsParsingSuccess = FALSE;

	Json::Value jInformationProvisionTime;
	bIsParsingSuccess = jsonUtils.getJSONObject(root, json_utils::INFOMATION_PROVISION_TIME, jInformationProvisionTime);

	if (!bIsParsingSuccess) {
		ETG_TRACE_ERR(("Parsing InformationProvisionTime FAILED!!"));
		return bIsParsingSuccess;
	}
//Date - Year
	tU16 u16Year = 0;
	bIsParsingSuccess = jsonUtils.gettU16UInt(jInformationProvisionTime, json_utils::U16_YEAR, u16Year);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}
	oInformationProvisionTime.u16Year = u16Year;
	ETG_TRACE_USR2(("oInformationProvisionTime.u16Year: %d", oInformationProvisionTime.u16Year));

	//Date - Month
	tU8 u8Month = 0;
	bIsParsingSuccess = jsonUtils.gettU8UInt(jInformationProvisionTime, json_utils::U8_MONTH, u8Month);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}
	oInformationProvisionTime.u8Month = u8Month;
	ETG_TRACE_USR2(("oInformationProvisionTime.u8Month: %d", oInformationProvisionTime.u8Month));

	//Date - Day
	tU8 u8Day = 0;
	bIsParsingSuccess = jsonUtils.gettU8UInt(jInformationProvisionTime, json_utils::U8_DAY, u8Day);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}
	oInformationProvisionTime.u8Day = u8Day;
	ETG_TRACE_USR2(("oInformationProvisionTime.u8Day: %d", oInformationProvisionTime.u8Day));

	//Date - Hour
	tU8 u8Hour = 0;
	bIsParsingSuccess = jsonUtils.gettU8UInt(jInformationProvisionTime, json_utils::U8_HOUR, u8Hour);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}
	oInformationProvisionTime.u8Hour = u8Hour;
	ETG_TRACE_USR2(("oInformationProvisionTime.u8Hour: %d", oInformationProvisionTime.u8Hour));

	//Date - Minutes
	tU8 u8Minutes = 0;
	bIsParsingSuccess = jsonUtils.gettU8UInt(jInformationProvisionTime, json_utils::U8_MINUTES, u8Minutes);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}
	oInformationProvisionTime.u8Min = u8Minutes;
	ETG_TRACE_USR2(("oInformationProvisionTime.u8Min: %d", oInformationProvisionTime.u8Min));

	//Date - Second
	tU8 u8Second = 0;
	bIsParsingSuccess = jsonUtils.gettU8UInt(jInformationProvisionTime, json_utils::U8_SECOND, u8Second);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}
	oInformationProvisionTime.u8Sec = u8Second;
	ETG_TRACE_USR2(("oInformationProvisionTime.u8Sec: %d", oInformationProvisionTime.u8Sec));

	if (!bIsParsingSuccess== TRUE){
		ETG_TRACE_USR2(("Parsing JSON FAILED!!"));
	}

	ETG_TRACE_USR2(("<- parseInformationProvisionTime()"));
	return bIsParsingSuccess;

}

tBool fc_usb_tcu_PRC_JSONParser::parseEntranceinformationList(
		Json::Value& jChargingSpotDataJPN,
		std::vector<T_tcu_Entranceinformation>& oEntranceinformationList) {
	ETG_TRACE_USR2((">> parseEntranceinformationList"));
	tBool bIsParsingSuccess = FALSE;

	//Get EntranceinformationList JSON message
	Json::Value jEntranceinformationList;
	bIsParsingSuccess = jsonUtils.getJSONArray(jChargingSpotDataJPN, json_utils::ENTRANCE_INFORMATION_LIST, jEntranceinformationList);

	if(bIsParsingSuccess == TRUE){
		//Resize
		oEntranceinformationList.resize(jEntranceinformationList.size());

		for (tC16 i=0; i < jEntranceinformationList.size(); i++){
			bIsParsingSuccess = parseEntranceinformationItem(jEntranceinformationList[i], oEntranceinformationList[i]);
		}

	}

	ETG_TRACE_USR2(("<- parseEntranceinformationList()"));
	return bIsParsingSuccess;


}

tBool fc_usb_tcu_PRC_JSONParser::parseEntranceinformationItem(
		Json::Value& jEntranceinformation,
		T_tcu_Entranceinformation& oEntranceinformation) {

	ETG_TRACE_USR2((">> parseEntranceinformationItem"));
	tBool bIsParsingSuccess = FALSE;

	//Get Entrance Info Data

	// POIIDPositionCoordinate
	Json::Value jLocation;
	bIsParsingSuccess = jsonUtils.getJSONObject(jEntranceinformation, json_utils::POI_POSITION_INFORMATION, jLocation);
	if (bIsParsingSuccess){
		bIsParsingSuccess = parseLocationCoordinate(jLocation, oEntranceinformation.POIPositionInformation);

	}

	bpstl::string strIdentificationName;
	bIsParsingSuccess = jsonUtils.getString(jEntranceinformation, json_utils::STR_IDENTIFICATION_NAME, strIdentificationName);
	if(bIsParsingSuccess){
	    oEntranceinformation.IdentificationName = strIdentificationName;
	}
	ETG_TRACE_USR2(("<- parseEntranceinformationItem()"));
	return bIsParsingSuccess;
}

tBool fc_usb_tcu_PRC_JSONParser::parsePartnersfacilityinformationList(
		Json::Value& jChargingSpotDataJPN,
		std::vector<T_tcu_Partnersfacilityinformation>& oPartnersfacilityinformationList) {
	ETG_TRACE_USR2((">> parsePartnersfacilityinformationList"));
	tBool bIsParsingSuccess = FALSE;

	//Get EntranceinformationList JSON message
	Json::Value jPartnersfacilityinformationList;
	bIsParsingSuccess = jsonUtils.getJSONArray(jChargingSpotDataJPN, json_utils::PARTNERS_FACILITY_INFORMATION_LIST, jPartnersfacilityinformationList);

	if(bIsParsingSuccess == TRUE){
		//Resize
		oPartnersfacilityinformationList.resize(jPartnersfacilityinformationList.size());

		for (tC16 i=0; i < jPartnersfacilityinformationList.size(); i++){
			bIsParsingSuccess = parsePartnersfacilityinformationItem(jPartnersfacilityinformationList[i], oPartnersfacilityinformationList[i]);
		}

	}

	ETG_TRACE_USR2(("<- parsePartnersfacilityinformationList()"));
	return bIsParsingSuccess;
}

tBool fc_usb_tcu_PRC_JSONParser::parsePartnersfacilityinformationItem(
		Json::Value& jPartnersfacility,
		T_tcu_Partnersfacilityinformation& oPartnersfacilityinformation) {
	ETG_TRACE_USR2((">> parsePartnersfacilityinformationItem"));
	tBool bIsParsingSuccess = FALSE;
	//Get Entrance Info Data
	bpstl::string strPartnersfacilityName;
	bIsParsingSuccess = jsonUtils.getString(jPartnersfacility, json_utils::STR_PARTNERS_FACILITY_NAME, strPartnersfacilityName);
	if(bIsParsingSuccess){
	    oPartnersfacilityinformation.PartnersFacilityName = strPartnersfacilityName;
	}
	ETG_TRACE_USR2(("<- parsePartnersfacilityinformationItem()"));
	return bIsParsingSuccess;
}

tBool fc_usb_tcu_PRC_JSONParser::parseInstallationfacilityinformationList(
		Json::Value& jChargingSpotDataJPN,
		std::vector<T_tcu_Installationfacilityinformation>& oInstallationfacilityList) {
	ETG_TRACE_USR2((">> parseInstallationfacilityinformationList"));
	tBool bIsParsingSuccess = FALSE;

	//Get EntranceinformationList JSON message
	Json::Value jInstallationfacilityinformationList;
	bIsParsingSuccess = jsonUtils.getJSONArray(jChargingSpotDataJPN, json_utils::INSTALLATION_FACILITY_INFORMATION_LIST, jInstallationfacilityinformationList);

	if(bIsParsingSuccess == TRUE){
		//Resize
		oInstallationfacilityList.resize(jInstallationfacilityinformationList.size());

		for (tC16 i=0; i < jInstallationfacilityinformationList.size(); i++){
			bIsParsingSuccess = parseInstallationfacilityinformationItem(jInstallationfacilityinformationList[i], oInstallationfacilityList[i]);
		}

	}

	ETG_TRACE_USR2(("<- parseInstallationfacilityinformationList()"));
	return bIsParsingSuccess;
}

tBool fc_usb_tcu_PRC_JSONParser::parseInstallationfacilityinformationItem(
		Json::Value& jInstallationfacility,
		T_tcu_Installationfacilityinformation& oInstallationfacility) {
	ETG_TRACE_USR2((">> parseInstallationfacilityinformationItem"));
	tBool bIsParsingSuccess = FALSE;
	//Get Entrance Info Data
	bpstl::string strInstallationfacilityName;
	bIsParsingSuccess = jsonUtils.getString(jInstallationfacility, json_utils::STR_INSTALLATION_FACILITY_NAME, strInstallationfacilityName);
	if(bIsParsingSuccess){
	    oInstallationfacility.InstallationFacilityName = strInstallationfacilityName;
	}
	ETG_TRACE_USR2(("<- parseInstallationfacilityinformationItem()"));
	return bIsParsingSuccess;
}

tBool fc_usb_tcu_PRC_JSONParser::parseChargingtypeList(
		Json::Value& jChargingSpotDataJPN,
		std::vector<T_tcu_Chargingtype>& oChargingtypeList) {
	ETG_TRACE_USR2((">> parseChargingtypeList"));
	tBool bIsParsingSuccess = FALSE;

	//Get EntranceinformationList JSON message
	Json::Value jChargingtypeList;
	bIsParsingSuccess = jsonUtils.getJSONArray(jChargingSpotDataJPN, json_utils::CHARGING_TYPE_LIST, jChargingtypeList);

	if(bIsParsingSuccess == TRUE){
		//Resize
		oChargingtypeList.resize(jChargingtypeList.size());

		for (tC16 i=0; i < jChargingtypeList.size(); i++){
			bIsParsingSuccess = parseChargingtypeItem(jChargingtypeList[i], oChargingtypeList[i]);
		}

	}

	ETG_TRACE_USR2(("<- parseChargingtypeList()"));
	return bIsParsingSuccess;
}

tBool fc_usb_tcu_PRC_JSONParser::parseChargingtypeItem(
		Json::Value& jChargingtype, T_tcu_Chargingtype& oChargingtype) {
	ETG_TRACE_USR2((">> parseChargingtypeItem"));
	tBool bIsParsingSuccess = FALSE;

	//Get Entrance Info Data
	tU8 u8ChargingMethod = 0;
	bIsParsingSuccess = jsonUtils.gettU8UInt(jChargingtype, json_utils::U8_CHARGING_METHOD, u8ChargingMethod);

	tU8 u8Setconnectortype = 0;
	if(bIsParsingSuccess == TRUE){
		bIsParsingSuccess = jsonUtils.gettU8UInt(jChargingtype, json_utils::U8_SET_CONNECTOR_TYPE, u8Setconnectortype);
	}

	tU8 u8Thenumberofsetconnector = 0;
	if(bIsParsingSuccess == TRUE){
		bIsParsingSuccess = jsonUtils.gettU8UInt(jChargingtype, json_utils::U8_THE_NUMBER_OF_CONNECTOR, u8Thenumberofsetconnector);
	}

	if(bIsParsingSuccess == TRUE){
		oChargingtype.u8ChargingMethod = u8ChargingMethod;
		oChargingtype.u8Setconnectortype = u8Setconnectortype;
		oChargingtype.u8Thenumberofsetconnector = u8Thenumberofsetconnector;
	}

	ETG_TRACE_USR2(("<- parseChargingtypeItem()"));
	return bIsParsingSuccess;
}

tBool fc_usb_tcu_PRC_JSONParser::parseChargingInfomationList(
		Json::Value& jChargingSpotDataJPN,
		std::vector<T_tcu_ChargingInfomation>& oChargingInfomationList) {
	ETG_TRACE_USR2((">> parseChargingInfomationList"));
	tBool bIsParsingSuccess = FALSE;

	//Get EntranceinformationList JSON message
	Json::Value jChargingInfomationList;
	bIsParsingSuccess = jsonUtils.getJSONArray(jChargingSpotDataJPN, json_utils::CHARGING_INFOMATION_LIST, jChargingInfomationList);

	if(bIsParsingSuccess == TRUE){
		//Resize
		oChargingInfomationList.resize(jChargingInfomationList.size());

		for (tC16 i=0; i < jChargingInfomationList.size(); i++){
			bIsParsingSuccess = parseChargingInfomationItem(jChargingInfomationList[i], oChargingInfomationList[i]);
		}

	}

	ETG_TRACE_USR2(("<- parseChargingInfomationList()"));
	return bIsParsingSuccess;

}

tBool fc_usb_tcu_PRC_JSONParser::parseChargingInfomationItem(
		Json::Value& jChargingInfomation,
		T_tcu_ChargingInfomation& oChargingInfomation) {
	ETG_TRACE_USR2((">> parseChargingInfomationItem"));
	tBool bIsParsingSuccess = FALSE;
	Json::Value jChargingType;
	bIsParsingSuccess = jsonUtils.getJSONObject(jChargingInfomation, json_utils::CHARGING_TYPE, jChargingType);
	//Get ChargingType Data
	if(bIsParsingSuccess == TRUE){
		bIsParsingSuccess = parseChargingtypeItem(jChargingType, oChargingInfomation.ChargingType);
	}

	if( bIsParsingSuccess == TRUE){
		tU16 u16Parkingnumber = 0;
		bIsParsingSuccess = jsonUtils.gettU16UInt(jChargingInfomation, json_utils::U16_PARKING_NUMBER, u16Parkingnumber);

//		tU8 u8Fixedvalue1 = 0;
//		if(bIsParsingSuccess == TRUE){
//			bIsParsingSuccess = jsonUtils.gettU8UInt(jChargingInfomation, json_utils::U8_FIXED_VALUE_1, u8Fixedvalue1);
//		}
//		tU8 u8Fixedvalue2 = 0;
//		if(bIsParsingSuccess == TRUE){
//			bIsParsingSuccess = jsonUtils.gettU8UInt(jChargingInfomation, json_utils::U8_FIXED_VALUE_2, u8Fixedvalue2);
//		}

		//cast string
		bpstl::string strDetailsinformation;
		if(bIsParsingSuccess == TRUE){
			bIsParsingSuccess = jsonUtils.getString(jChargingInfomation, json_utils::STR_DETAILS_INFORMATION, strDetailsinformation);
		}
		if(bIsParsingSuccess == TRUE){
			oChargingInfomation.u16Parkingnumber = u16Parkingnumber;
			oChargingInfomation.strDetailsinformation = strDetailsinformation;

		}

	}

	ETG_TRACE_USR2(("<- parseChargingInfomationItem()"));
	return bIsParsingSuccess;
}

tBool fc_usb_tcu_PRC_JSONParser::parseVacancyChargingInfomationList(
		Json::Value& jVacancySpotDataJPN,
		std::vector<T_tcu_ChargingInfomation>& oChargingInfomationList) {
	ETG_TRACE_USR2((">> parseVacancyChargingInfomationList"));
	tBool bIsParsingSuccess = FALSE;

	//Get EntranceinformationList JSON message
	Json::Value jChargingInfomationList;
	bIsParsingSuccess = jsonUtils.getJSONArray(jVacancySpotDataJPN, json_utils::CHARGING_INFOMATION_LIST, jChargingInfomationList);

	if(bIsParsingSuccess == TRUE){
		//Resize
		oChargingInfomationList.resize(jChargingInfomationList.size());

		for (tC16 i=0; i < jChargingInfomationList.size(); i++){
			bIsParsingSuccess = parseVacancyChargingInfomationItem(jChargingInfomationList[i], oChargingInfomationList[i]);
		}

	}

	ETG_TRACE_USR2(("<- parseVacancyChargingInfomationList()"));
	return bIsParsingSuccess;
}

tBool fc_usb_tcu_PRC_JSONParser::parseVacancyChargingInfomationItem(
		Json::Value& jChargingInfomation,
		T_tcu_ChargingInfomation& oChargingInfomation) {

	ETG_TRACE_USR2((">> parseVacancyChargingInfomationItem"));
	tBool bIsParsingSuccess = FALSE;
	Json::Value jChargingType;
	bIsParsingSuccess = jsonUtils.getJSONObject(jChargingInfomation, json_utils::CHARGING_TYPE, jChargingType);
	//Get ChargingType Data
	if(bIsParsingSuccess == TRUE){
		bIsParsingSuccess = parseChargingtypeItem(jChargingType, oChargingInfomation.ChargingType);
	}

	if( bIsParsingSuccess == TRUE){
		tU16 u16Parkingnumber = 0;
		bIsParsingSuccess = jsonUtils.gettU16UInt(jChargingInfomation, json_utils::U16_PARKING_NUMBER, u16Parkingnumber);

//		tU8 u8Fixedvalue1 = 0;
//		if(bIsParsingSuccess == TRUE){
//			bIsParsingSuccess = jsonUtils.gettU8UInt(jChargingInfomation, json_utils::U8_FIXED_VALUE_1, u8Fixedvalue1);
//		}
//		tU8 u8Fixedvalue2 = 0;
//		if(bIsParsingSuccess == TRUE){
//			bIsParsingSuccess = jsonUtils.gettU8UInt(jChargingInfomation, json_utils::U8_FIXED_VALUE_2, u8Fixedvalue2);
//		}

		//cast string
		bpstl::string strDetailsinformation;
		if(bIsParsingSuccess == TRUE){
			bIsParsingSuccess = jsonUtils.getString(jChargingInfomation, json_utils::STR_DETAILS_INFORMATION, strDetailsinformation);
		}

		tU8 u8VacancyStatus = 0;
		if(bIsParsingSuccess == TRUE){
			bIsParsingSuccess = jsonUtils.gettU8UInt(jChargingInfomation, json_utils::U8_VACANCY_STATUS, u8VacancyStatus);
		}

		tU8 u8NumOfAvailableConnector = 0;
		if(bIsParsingSuccess == TRUE){
			bIsParsingSuccess = jsonUtils.gettU8UInt(jChargingInfomation, json_utils::U8_NUMBER_OF_AVAILABLE_CONNECTOR, u8NumOfAvailableConnector);
		}
		tU8 u8NumOfBusyConnector = 0;
		if(bIsParsingSuccess == TRUE){
			bIsParsingSuccess = jsonUtils.gettU8UInt(jChargingInfomation, json_utils::U8_NUMBER_OF_BUSY_CONNECTOR, u8NumOfBusyConnector);
		}

		tU8 u8NumOfUnknownConnector = 0;
		if(bIsParsingSuccess == TRUE){
			bIsParsingSuccess = jsonUtils.gettU8UInt(jChargingInfomation, json_utils::U8_NUMBER_OF_UNKNOWN_CONNECTOR, u8NumOfUnknownConnector);
		}

		if(bIsParsingSuccess == TRUE){
			bIsParsingSuccess = parseInformationProvisionTime(jChargingInfomation, oChargingInfomation.InfoProvisionTime);
		}

		bpstl::string strInfomationProvider;
		if(bIsParsingSuccess == TRUE){
			bIsParsingSuccess = jsonUtils.getString(jChargingInfomation, json_utils::STR_INFOMATION_PROVIDER, strInfomationProvider);
		}

		bpstl::string strNetworkName;
		if(bIsParsingSuccess == TRUE){
			bIsParsingSuccess = jsonUtils.getString(jChargingInfomation, json_utils::STR_NETWORK_NAME, strNetworkName);
		}

		tU8 u8ReservationAvailabilityFlag = 0;
		if(bIsParsingSuccess == TRUE){
			bIsParsingSuccess = jsonUtils.gettU8UInt(jChargingInfomation, json_utils::U8_RESERVATION_AVAILABILITY_FLAG, u8ReservationAvailabilityFlag);
		}

		if(bIsParsingSuccess == TRUE){
			oChargingInfomation.u16Parkingnumber = u16Parkingnumber;
			oChargingInfomation.strDetailsinformation = strDetailsinformation;
			oChargingInfomation.u8VacancyStatus = u8VacancyStatus;
			oChargingInfomation.u8NumberOfAvailableConnector = u8NumOfAvailableConnector;
			oChargingInfomation.u8NumberOfBusyConnector = u8NumOfBusyConnector;
			oChargingInfomation.u8NumberOfUnKnownConnector = u8NumOfUnknownConnector;
			oChargingInfomation.strInfomationProvider = strInfomationProvider;
			oChargingInfomation.strNetworkName = strNetworkName;
			oChargingInfomation.u8ReservationAvailableFlag = u8ReservationAvailabilityFlag;

		}

	}

	ETG_TRACE_USR2(("<- parseVacancyChargingInfomationItem()"));
	return bIsParsingSuccess;
}



//--------------------------------------------------------------------------------------------------------------------------------------
tBool fc_usb_tcu_PRC_JSONParser::parseLocationForChargingSpotData(Json::Value & ChargingSpotData, T_tcu_Location& oLocation)
{
	ETG_TRACE_USR2((">> parseLocationForChargingSpotData"));

	Json::Value jLocation;
	tBool bIsParsingSuccess = jsonUtils.getJSONObject(ChargingSpotData, json_utils::LOCATION, jLocation);

	if(bIsParsingSuccess == TRUE)
	{
		//Get the channel content ID
		tU8 u8Direction = 0;
		bIsParsingSuccess = jsonUtils.gettU8UInt(jLocation, json_utils::U8_DIRECTION, u8Direction);

		//Get the Longitude Degree
		tU8 u8Longitude_degree = 0;
		if(bIsParsingSuccess == TRUE)
		{
			bIsParsingSuccess = jsonUtils.gettU8UInt(jLocation, json_utils::U8_LONGITUDE_DEGREE, u8Longitude_degree);
		}

		//Get the Longitude minute
		tU8 u8Longitude_minute = 0;
		if(bIsParsingSuccess == TRUE)
		{
			bIsParsingSuccess = jsonUtils.gettU8UInt(jLocation, json_utils::U8_LONGITUDE_MINUTE, u8Longitude_minute);
		}

		//Get the Longitude second
		tU16 u16Longitude_second = 0;
		if(bIsParsingSuccess == TRUE)
		{
			bIsParsingSuccess = jsonUtils.gettU16UInt(jLocation, json_utils::U16_LONGITUDE_SECOND, u16Longitude_second);
		}
		//Get the Latitude degree
		tU8 u8Latitude_degree = 0;
		if(bIsParsingSuccess == TRUE)
		{
			bIsParsingSuccess = jsonUtils.gettU8UInt(jLocation, json_utils::U8_LATITUDE_DEGREE, u8Latitude_degree);
		}

		//Get the Latitude minute
		tU8 u8Latitude_minute = 0;
		if(bIsParsingSuccess == TRUE)
		{
			bIsParsingSuccess = jsonUtils.gettU8UInt(jLocation, json_utils::U8_LATITUDE_MINUTE, u8Latitude_minute);
		}

		//Get the Latitude second
		tU16 u16Latitude_second = 0;
		if(bIsParsingSuccess == TRUE)
		{
			bIsParsingSuccess = jsonUtils.gettU16UInt(jLocation, json_utils::U16_LATITUDE_SECOND, u16Latitude_second);
		}

		if(bIsParsingSuccess == TRUE)
		{
			T_tcu_Location tempoLocation(u8Direction,
										 u8Longitude_degree,
										 u8Longitude_minute,
										 u16Longitude_second,
										 u8Latitude_degree,
										 u8Latitude_minute,
										 u16Latitude_second);
			oLocation = tempoLocation;
		}
	}
	if (!bIsParsingSuccess)	{
		ETG_TRACE_USR2(("parseLocationForChargingSpotData JSON FAILED!!"));
	}

	ETG_TRACE_USR2(("<< parseLocationForChargingSpotData"));
	return bIsParsingSuccess;
}

tBool fc_usb_tcu_PRC_JSONParser::vParseVacantStationsData(
		tU32& u32ClientToken,
		Json::Value& root, T_tcu_response_vacancy_stations_list_result& oVacantStationsData)
{
	ETG_TRACE_USR2(("<< vParseVacantStationsDataJSON"));
	tBool bIsParsingSuccess = false;

//	tU32 u32ClientToken = 0;
	bIsParsingSuccess = jsonUtils.gettU32UInt(root, json_utils::U32_REQ_ID, u32ClientToken);
	ETG_TRACE_USR2(("u32ClientToken: %u", u32ClientToken));
	//Get Vacant stations JSON message
	Json::Value jVSD;
	if(bIsParsingSuccess)
		bIsParsingSuccess = jsonUtils.getJSONObject(root, json_utils::VACANCY_STATIONS, jVSD);

	if (bIsParsingSuccess)
	{
		bIsParsingSuccess = parseVacantStationsDataHeader(jVSD, oVacantStationsData);
	}

	if (bIsParsingSuccess)
	{
		//Get POIIDList
		Json::Value jPOIIDInfoList;
		bIsParsingSuccess = jsonUtils.getJSONArray(jVSD, json_utils::POIID_LIST_DATA, jPOIIDInfoList);

		if(bIsParsingSuccess)
		{
			oVacantStationsData.VacancyStations.POIIDInfoList.resize(jPOIIDInfoList.size());
			for (tC16 i = 0; i < jPOIIDInfoList.size(); i++)
			{
				if (bIsParsingSuccess)
				{
					bIsParsingSuccess = parseVacantStationsDataInformation(jPOIIDInfoList[i], oVacantStationsData.VacancyStations.POIIDInfoList[i]);
				}
			}
		}
	}

	if (!bIsParsingSuccess)
	{
		ETG_TRACE_USR2(("Parsing JSON FAILED!!"));
	}

	return bIsParsingSuccess;	
}

tBool fc_usb_tcu_PRC_JSONParser::parseVacantStationsDataHeader(Json::Value & jVSD, T_tcu_response_vacancy_stations_list_result & oVacantStationsData)
{
	ETG_TRACE_USR2(("<< parseVacantStationsDataHeader"));

	tBool bIsParsingSuccess = false;
    Json::Value jVSDHeader;
    tBool boolGetVSDHeaderJSONObj = jsonUtils.getJSONObject(jVSD, json_utils::LIST_OF_CHARGING_STATIONS_HEADER, jVSDHeader);

    if (boolGetVSDHeaderJSONObj)
    {
		//Get Number Of POI ID
		tU32 u32NumberOfPOIID;
		bIsParsingSuccess = jsonUtils.gettU32UInt(jVSDHeader, json_utils::U32_NUMBER_OF_POI_ID, u32NumberOfPOIID);
		if (bIsParsingSuccess)
		{
			oVacantStationsData.VacancyStations.VacancyStationsResponseHeader.u32NumberOfPOIID = u32NumberOfPOIID;
		}
	}

    return bIsParsingSuccess;	
}

tBool fc_usb_tcu_PRC_JSONParser::parseVacantStationsDataInformation(Json::Value& jPOIIDData, T_tcu_vacancy_station_response_datarecord& oPOIIDInfo)
{
	ETG_TRACE_USR2(("-> parseVacantStationsPOIIDDataInformation()"));
	tBool bIsParsingSuccess = FALSE;

	//Get POIID
	tU32 u32POIID;
	bIsParsingSuccess = jsonUtils.gettU32UInt(jPOIIDData, json_utils::U32_POIID, u32POIID);

	if(bIsParsingSuccess)
	{
		oPOIIDInfo.u32POIID = u32POIID;
	}

	// POIIDPositionCoordinate
	Json::Value jLocation;
	bIsParsingSuccess = jsonUtils.getJSONObject(jPOIIDData, json_utils::LOCATION, jLocation);
	if (bIsParsingSuccess)
	{
		bIsParsingSuccess = parseLocationCoordinate(jLocation, oPOIIDInfo.Location);
	}

	ETG_TRACE_USR2(("<- parsePOIIDDataInformation()"));
	return bIsParsingSuccess;
}

tBool fc_usb_tcu_PRC_JSONParser::vParseVICSData(Json::Value & VICSData, T_tcu_VICS_Response_Data& oVICSData) 
{		
	
	Json::Value jVICSData;
//	Json::ArrayIndex  	index	= 0;
	tBool bIsParsingSuccess = jsonUtils.getJSONArray(VICSData, json_utils::VICS_FILE_PATH, jVICSData);	
	
	if (bIsParsingSuccess)	
	{
		
		tU8 DataElement = 0;
		
		
		for (tC16 i = 0; i < jVICSData.size() ; i++)
		{	
			DataElement = jVICSData[i].asUInt();			
			oVICSData.VICSResponseData.push_back(DataElement);
		}
	}
	
	return bIsParsingSuccess;
};

tBool fc_usb_tcu_PRC_JSONParser::bParsePartAuthResponseJSON(Json::Value & response, T_tcu_PartAuthentication_Response_Data& tPartAuth)
{
	ETG_TRACE_USR2(("<< bParsePartAuthResponseJSON"));
	tBool bIsParsingSuccess = FALSE;

	//Get Download PartAuthentication Data Response JSON message
	Json::Value jPartAuth;
	bIsParsingSuccess = jsonUtils.getJSONObject(response, json_utils::PART_AUTH_RESPONSE, jPartAuth);
	if (!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}
	
	//Copy the status code
	tU16  u16StatusCode = 0;
	bIsParsingSuccess = jsonUtils.gettU16UInt(jPartAuth, json_utils::PART_AUTH_STATUS_CODE, u16StatusCode);
	if (!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}
	tPartAuth.u16StatusCode = u16StatusCode;

	//Copy the request type
	tU8 u8RequestType = 0;
	bIsParsingSuccess = jsonUtils.gettU8UInt(jPartAuth, json_utils::PART_AUTH_REQUEST_TYPE, u8RequestType);
	if (!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}
	tPartAuth.u8RequestType = u8RequestType;

	Json::Value jPartAuthBody;
	bIsParsingSuccess = jsonUtils.getJSONObject(jPartAuth, json_utils::PART_AUTH_BODY, jPartAuthBody);
	if (!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}

	if (u16StatusCode == 200){

		bpstl::string  strSN;
		bIsParsingSuccess = jsonUtils.getString(jPartAuthBody, json_utils::PART_AUTH_SN, strSN);
		if (!bIsParsingSuccess)
		{
			return bIsParsingSuccess;
		}
		tPartAuth.strSerialNumber = strSN;

		if (u8RequestType == 0){
			//bpstl::string  strCertificate;
			Json::Value jCrtArr;
			//bIsParsingSuccess = jsonUtils.getString(jPartAuthBody, json_utils::PART_AUTH_CERTIFICATE, strCertificate);
			bIsParsingSuccess = jsonUtils.getJSONArray(jPartAuthBody, json_utils::PART_AUTH_CERTIFICATE, jCrtArr);
			if (!bIsParsingSuccess)
			{
				return bIsParsingSuccess;
			}
			//tPartAuth.strCertificate = strCertificate;
			ETG_TRACE_USR2(("Recieved Certificate"));
			ETG_TRACE_USR2(("Opening Certificate file"));
			CertificateFile.open(CertificateFilePath, std::ios_base::app | std::ios_base::out | std::ios_base::in);

			if (CertificateFile.is_open()){
				ETG_TRACE_USR2(("Writing to Certificate file"));
				int size = jCrtArr.size();
				for (int index = 0; index < size; ++index){
					CertificateFile << jCrtArr[index].asString();
					CertificateFile << "\n";
				}
				/*for (Json::ValueIterator itr = jCrtArr.begin(); itr != jCrtArr.end(); itr++){
				CertificateFile << *itr;
				//CertificateFile << "\n";
				}*/
			}

			CertificateFile.close();
		}
		else if (u8RequestType == 1){
			bpstl::string  strRegion;
			bIsParsingSuccess = jsonUtils.getString(jPartAuthBody, json_utils::PART_AUTH_REGION, strRegion);
			if (!bIsParsingSuccess)
			{
				return bIsParsingSuccess;
			}
			tPartAuth.strRegion = strRegion;
		}
		else{
			bpstl::string  strPartition;
			bIsParsingSuccess = jsonUtils.getString(jPartAuthBody, json_utils::PART_AUTH_PARTITION, strPartition);
			if (!bIsParsingSuccess)
			{
				return bIsParsingSuccess;
			}
			tPartAuth.strPartition = strPartition;
		}
	}
	else{

		bpstl::string  strErrorId;
		bIsParsingSuccess = jsonUtils.getString(jPartAuthBody, json_utils::PART_AUTH_ERROR_ID, strErrorId);
		if (!bIsParsingSuccess)
		{
			return bIsParsingSuccess;
		}
		tPartAuth.strErrorId = strErrorId;

		bpstl::string  strErrorMessage;
		bIsParsingSuccess = jsonUtils.getString(jPartAuthBody, json_utils::PART_AUTH_ERROR_MESSAGE, strErrorMessage);
		if (!bIsParsingSuccess)
		{
			return bIsParsingSuccess;
		}
		tPartAuth.strErrorMessage = strErrorMessage;
	}



	return bIsParsingSuccess;
};

tBool fc_usb_tcu_PRC_JSONParser::bParseUserAuthResponseJSON(Json::Value & response, T_tcu_UserAuthToken_Response_Data& tUserAuth)
{
	ETG_TRACE_USR2(("<< bParseUserAuthResponseJSON"));
	tBool bIsParsingSuccess = FALSE;

	//Get UserAuthentication Response JSON message
	Json::Value jUserAuth;
	bIsParsingSuccess = jsonUtils.getJSONObject(response, json_utils::USER_AUTH_RESPONSE, jUserAuth);
	if (!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}

	//Copy the Request type
	tU8  u8RequestType = 0;
	bIsParsingSuccess = jsonUtils.gettU8UInt(jUserAuth, json_utils::USER_AUTH_REQUEST_TYPE, u8RequestType);
	if (!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}
	tUserAuth.u8RequestType = u8RequestType;

	//Copy the status code
	tU16  u16StatusCode = 0;
	bIsParsingSuccess = jsonUtils.gettU16UInt(jUserAuth, json_utils::USER_AUTH_STATUS_CODE, u16StatusCode);
	if (!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}
	tUserAuth.u16StatusCode = u16StatusCode;

	/*Json::Value jUserAuthBody;
	bIsParsingSuccess = jsonUtils.getJSONObject(jUserAuth, json_utils::USER_AUTH_BODY, jUserAuthBody);
	if (!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}*/

	if (u16StatusCode == 200){

		bpstl::string  strAccessToken;
		bIsParsingSuccess = jsonUtils.getString(jUserAuth, json_utils::USER_AUTH_ACCESS_TOKEN, strAccessToken);
		if (!bIsParsingSuccess)
		{
			return bIsParsingSuccess;
		}
		tUserAuth.strAccessToken = strAccessToken;

		bpstl::string  strRefreshToken;
		bIsParsingSuccess = jsonUtils.getString(jUserAuth, json_utils::USER_AUTH_REFRESH_TOKEN, strRefreshToken);
		if (!bIsParsingSuccess)
		{
			return bIsParsingSuccess;
		}
		tUserAuth.strRefreshToken = strRefreshToken;

		/*bpstl::string  strScope;
		bIsParsingSuccess = jsonUtils.getString(jUserAuthBody, json_utils::USER_AUTH_SCOPE, strScope);
		if (!bIsParsingSuccess)
		{
			return bIsParsingSuccess;
		}
		tUserAuth.strScope = strScope;*/

		bpstl::string  strIdToken;
		bIsParsingSuccess = jsonUtils.getString(jUserAuth, json_utils::USER_AUTH_ID_TOKEN, strIdToken);
		if (!bIsParsingSuccess)
		{
			return bIsParsingSuccess;
		}
		tUserAuth.strIdToken = strIdToken;

		tU32  u32ExpiresIn = 0;
		bIsParsingSuccess = jsonUtils.gettU32UInt(jUserAuth, json_utils::USER_AUTH_EXPIRES_IN, u32ExpiresIn);
		if (!bIsParsingSuccess)
		{
			return bIsParsingSuccess;
		}
		tUserAuth.u32ExpiresIn = u32ExpiresIn;

	}

	else{

		bpstl::string  strError;
		bIsParsingSuccess = jsonUtils.getString(jUserAuth, json_utils::USER_AUTH_ERROR, strError);
		if (!bIsParsingSuccess)
		{
			return bIsParsingSuccess;
		}
		tUserAuth.strError = strError;

		/*bpstl::string  strErrorDescription;
		bIsParsingSuccess = jsonUtils.getString(jUserAuth, json_utils::USER_AUTH_ERROR_DESCRIPTION, strErrorDescription);
		if (!bIsParsingSuccess)
		{
			return bIsParsingSuccess;
		}
		tUserAuth.strErrorDescription = strErrorDescription;*/

	}

	return bIsParsingSuccess;
};

tBool fc_usb_tcu_PRC_JSONParser::bGetTokenArray(Json::Value& root_in, Json::Value& root_out)
{
	ETG_TRACE_USR2(("<< bGetTokenArray"));
	tBool bIsParsingSuccess = jsonUtils.getJSONArray(root_in, json_utils::USER_AUTH_TOKEN, root_out);
	return bIsParsingSuccess;
}

tBool fc_usb_tcu_PRC_JSONParser::bParseDecodedIdToken(Json::Value& root_in, std::string& root_out)
{
	ETG_TRACE_USR2(("<< bParseDecodedIdToken"));
	tBool bIsParsingSuccess = FALSE;
	Json::Value jUserAuth;

	//Get DecodeIdToken Response JSON message
	bIsParsingSuccess = jsonUtils.getJSONObject(root_in, json_utils::USER_AUTH_RESPONSE, jUserAuth);
	if (!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}

	//Get decoded id_token JSON message
	Json::Value jIdToken;
	bIsParsingSuccess = jsonUtils.getJSONObject(jUserAuth, json_utils::USER_AUTH_ID_TOKEN, jIdToken);
	if (!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}

	//Copy KID
	//bpstl::string  strKID;
	bIsParsingSuccess = jsonUtils.getString(jIdToken, json_utils::DECODED_TOKEN_KID, root_out);
	if (!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}

	return bIsParsingSuccess;
}


